set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9106629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-4-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      65,
      2,
      NULL,
      2,
      '124313',
      1.365356,
      ' 7-23-2002',
      37,
      NULL,
      1.308440,
      NULL,
      2,
      1,
      1,
      NULL,
      0.479673,
      2,
      0,
      NULL,
      1.866361,
      1.660140,
      2,
      1,
      0,
      4,
      1,
      3,
      NULL,
      1,
      1.881754,
      1,
      1.583259,
      1.534012,
      1.642352,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.624162,
      NULL,
      NULL,
      0.362074,
      0,
      NULL,
      1.545583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231266,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.899873,
      4.266005,
      1.478660,
      3.311657,
      NULL,
      1.588820,
      1.488918,
      3,
      1.184097,
      4,
      NULL,
      1,
      5.932839,
      NULL,
      1.784909,
      1,
      1,
      0.846412,
      NULL,
      0.279707,
      2,
      3.522059,
      NULL,
      0,
      0.422660,
      NULL,
      1.856319,
      4.961095,
      0,
      2.947136,
      7,
      3.911238,
      1,
      5.499236,
      NULL,
      0,
      7,
      4,
      0.064377,
      NULL,
      1.363819,
      NULL,
      3.275271,
      NULL,
      4.176997,
      NULL,
      4,
      NULL,
      NULL,
      0.426495,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.210374,
      0,
      NULL,
      1,
      0.050524,
      NULL,
      1.381680,
      1.528068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851212,
      NULL,
      NULL,
      NULL,
      NULL,
      0.255572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.382131,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5.179409,
      1,
      0,
      1,
      4.432758,
      0,
      NULL,
      NULL,
      1,
      3,
      0.094354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.352748,
      NULL,
      NULL,
      3.052183,
      3,
      3.145354,
      1.656104,
      1.088006,
      2,
      0.455765,
      0,
      1.710204,
      0,
      1,
      1.206704,
      0.174600,
      NULL,
      3,
      1,
      1.271470,
      1.019939,
      1,
      0.199483,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.520128,
      '00200',
      NULL,
      '',
      NULL,
      '04033',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


