set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9106629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '0334044',
      64,
      5,
      3.744625,
      3,
      NULL,
      1,
      ' 8- 4-1991',
      1,
      NULL,
      1.902178,
      NULL,
      2,
      NULL,
      NULL,
      0.753726,
      0,
      0.636671,
      1,
      1.502906,
      1,
      0.108184,
      3,
      NULL,
      0.685775,
      3,
      0.386320,
      0.052726,
      NULL,
      1.621283,
      1,
      1,
      1,
      0,
      3.418508,
      0,
      4.911187,
      3,
      1,
      1,
      NULL,
      NULL,
      0.994659,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.870239,
      0,
      0.380758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.024935,
      2.469618,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.291203,
      1,
      NULL,
      0,
      0.999242,
      NULL,
      NULL,
      1,
      1,
      1.582299,
      0.695474,
      0,
      NULL,
      0,
      NULL,
      1.689246,
      NULL,
      4,
      0.553176,
      1.721438,
      1.012836,
      5,
      0.783777,
      NULL,
      1,
      4,
      0,
      7.029527,
      0.754982,
      3,
      8,
      7,
      5.188021,
      NULL,
      NULL,
      9.836781,
      8,
      8.415710,
      4,
      1,
      3.101057,
      3,
      0.041927,
      1.651556,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      NULL,
      0.902315,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.431941,
      NULL,
      NULL,
      NULL,
      NULL,
      4.047412,
      1,
      NULL,
      NULL,
      2.986291,
      0.437055,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.811035,
      1.323737,
      5.796944,
      0,
      1,
      1.430061,
      NULL,
      NULL,
      NULL,
      NULL,
      8.103735,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568984,
      2,
      2,
      0,
      0.763492,
      0,
      0.149619,
      1,
      1,
      0.683451,
      2,
      1.806741,
      1,
      1,
      1.772447,
      2.113427,
      0.557139,
      0.345618,
      1.310314,
      NULL,
      1.054006,
      3,
      1.189410,
      1,
      0.627340,
      0,
      NULL,
      1,
      1.671016,
      0.034793,
      0.452367,
      1,
      0.768900,
      1.505789,
      0,
      0,
      1,
      0,
      0,
      0.256812,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '24034',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


