set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9687307';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      '24311130',
      NULL,
      58.545823,
      '3123013',
      15.725911,
      1,
      2.843772,
      1,
      NULL,
      5,
      ' 4- 6-1979',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1.470738,
      NULL,
      1.374599,
      1.320993,
      0.691480,
      NULL,
      0,
      NULL,
      1.590158,
      1,
      NULL,
      1.800676,
      NULL,
      NULL,
      0.993111,
      1.473611,
      NULL,
      0,
      3,
      0.022958,
      0.092476,
      0,
      NULL,
      NULL,
      1.597905,
      NULL,
      NULL,
      1,
      0,
      0,
      1.714967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043367,
      1.977443,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.440582,
      5,
      NULL,
      1,
      NULL,
      0.481859,
      0.773744,
      0.612171,
      1.218780,
      0.459003,
      0.755887,
      0.468072,
      NULL,
      1.365502,
      0.265718,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.105117,
      0.567234,
      NULL,
      0.482348,
      2.930114,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.678928,
      NULL,
      6,
      5,
      0,
      NULL,
      1,
      4,
      NULL,
      2,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.078412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.780591,
      0,
      0,
      0,
      0,
      0,
      0.698829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.341195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.758097,
      NULL,
      NULL,
      NULL,
      4.050417,
      1,
      NULL,
      2.698948,
      2,
      NULL,
      0.282774,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.403889,
      0,
      NULL,
      2.552160,
      0.340656,
      NULL,
      0,
      0,
      1,
      0,
      1.046572,
      1.668240,
      1,
      0.377578,
      1.360609,
      NULL,
      0.409211,
      0.828360,
      0.775358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.180600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.509720,
      '00102',
      '3111',
      NULL,
      0,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      4,
      3.697007,
      1,
      NULL,
      NULL,
      4,
      7.271103,
      8.560583,
      NULL);
commit;
end;
/


