set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9750213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '344',
      '43141134',
      57.459417,
      13.428861,
      '1131222',
      0,
      NULL,
      3,
      0,
      '221201',
      NULL,
      NULL,
      17.528413,
      43.933358,
      0.547286,
      NULL,
      4,
      NULL,
      0,
      NULL,
      1.904694,
      0,
      0,
      3,
      0,
      1.848340,
      1.837931,
      2.429188,
      NULL,
      1.476878,
      NULL,
      0,
      9,
      1.783023,
      1,
      0.276386,
      NULL,
      1,
      NULL,
      1,
      3.905819,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.767511,
      NULL,
      NULL,
      1,
      0,
      1.542165,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.144830,
      1,
      2.608856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      1.379590,
      4,
      0.018027,
      NULL,
      1,
      NULL,
      NULL,
      1.499619,
      0,
      1,
      NULL,
      NULL,
      0.852468,
      1.697331,
      NULL,
      1.801213,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      0.025424,
      3,
      NULL,
      5,
      2,
      5,
      2.955991,
      NULL,
      3,
      NULL,
      NULL,
      5.819107,
      6,
      NULL,
      2,
      7.911318,
      2,
      NULL,
      6,
      2,
      1.695995,
      1.345334,
      NULL,
      2,
      0.826978,
      0,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909164,
      0.311768,
      NULL,
      2,
      NULL,
      0.212934,
      0.843993,
      0.505752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835335,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1,
      1,
      0,
      7.185904,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.645161,
      NULL,
      5.570100,
      0.952889,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.055043,
      2.201144,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.203403,
      0.529753,
      NULL,
      1.483338,
      0,
      1,
      1.755691,
      1.810158,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0.690530,
      NULL,
      1.710716,
      1.373370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.438422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '12124',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      1.729009,
      5.464575,
      5.102820,
      0.392062,
      1,
      2,
      2.330330,
      NULL,
      2.406651);
commit;
end;
/


