set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9750213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '000',
      '21111303',
      NULL,
      NULL,
      NULL,
      9,
      1,
      2.684470,
      3,
      '202011',
      5.523911,
      ' 8-29-1997',
      55,
      5,
      0,
      NULL,
      2,
      1.636156,
      3.687122,
      0.459018,
      1.956809,
      2,
      1.576545,
      NULL,
      NULL,
      1.118930,
      NULL,
      0,
      1.873855,
      0.734274,
      1.867108,
      1.289106,
      0,
      0,
      0.171280,
      NULL,
      1.204411,
      NULL,
      NULL,
      1,
      1.402849,
      0.127974,
      1,
      0,
      NULL,
      NULL,
      1.265399,
      NULL,
      NULL,
      7.779584,
      5,
      0,
      3.752732,
      1.372317,
      1,
      2.052150,
      NULL,
      1.285990,
      3,
      3.122403,
      NULL,
      0,
      NULL,
      0,
      2,
      2.564593,
      0.468995,
      NULL,
      0.902915,
      0,
      4.335710,
      6.600955,
      1,
      1,
      4.006396,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1,
      2,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1.166684,
      1,
      1,
      0,
      0,
      0,
      0.145175,
      1.055678,
      NULL,
      NULL,
      0,
      NULL,
      3.519191,
      8,
      0.291604,
      6,
      1.024920,
      0,
      0.419786,
      NULL,
      5.544952,
      2,
      5,
      0.892435,
      1.806240,
      1,
      4.313348,
      6,
      NULL,
      6,
      NULL,
      0.991645,
      1,
      9,
      0.064352,
      2,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.644655,
      0,
      1,
      1.954029,
      1,
      NULL,
      0.460819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.999736,
      NULL,
      0.322735,
      NULL,
      NULL,
      NULL,
      NULL,
      4.252252,
      3,
      4,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.084120,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839477,
      3.787804,
      2.554228,
      2.424878,
      NULL,
      1.682855,
      2.097165,
      2.548404,
      0,
      2,
      1.016168,
      1,
      0,
      0.757157,
      1.927750,
      0,
      0,
      1.398749,
      1.830010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.815566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331412,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.338135,
      NULL,
      '',
      NULL,
      1.165502,
      0.916634,
      3.394939,
      0,
      1.490623,
      1.480415,
      1.273174,
      3,
      NULL);
commit;
end;
/


