set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9750213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '414',
      '14240410',
      13,
      NULL,
      '1113112',
      4,
      2,
      0.509625,
      1,
      '201322',
      5,
      ' 6-19-1996',
      27,
      27,
      NULL,
      NULL,
      0.471948,
      3,
      0.727178,
      0,
      NULL,
      1,
      1,
      3,
      0,
      0,
      4,
      0.253777,
      NULL,
      NULL,
      0.079281,
      5.373416,
      5,
      1.343091,
      0,
      NULL,
      1,
      0.355231,
      4.776717,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      0.940879,
      1.620240,
      1,
      0,
      NULL,
      2.417551,
      1,
      0,
      2,
      NULL,
      0,
      2,
      0,
      0.998187,
      0.685334,
      2,
      2.276918,
      NULL,
      NULL,
      0,
      5,
      5.474109,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      0.665838,
      NULL,
      NULL,
      1.699349,
      NULL,
      3,
      1.468741,
      1.781248,
      NULL,
      2,
      1,
      0.845949,
      0.323962,
      0.589896,
      1,
      1,
      2.735709,
      1.526384,
      0.694264,
      NULL,
      0,
      1.963237,
      NULL,
      NULL,
      6.748511,
      1.490905,
      5.865511,
      8.440518,
      NULL,
      2,
      0,
      3.303750,
      0,
      NULL,
      NULL,
      4,
      0.460328,
      1,
      3,
      NULL,
      6.071872,
      NULL,
      0,
      1.794344,
      NULL,
      5,
      2,
      5.255840,
      NULL,
      1.144547,
      4,
      NULL,
      0,
      1,
      6.054794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      NULL,
      1.810963,
      0,
      0.093971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.412796,
      NULL,
      0,
      1,
      3.862054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800808,
      1.635734,
      NULL,
      0.994904,
      1.441886,
      0,
      1.581873,
      NULL,
      NULL,
      NULL,
      NULL,
      3.433645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.719212,
      0.010021,
      3.980527,
      0,
      0.792849,
      NULL,
      3.196037,
      1.159014,
      NULL,
      NULL,
      1,
      1,
      1.171429,
      0.261557,
      1,
      NULL,
      1,
      1,
      1.004238,
      0.835920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '23344',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.294927,
      '',
      '',
      '',
      0,
      NULL,
      5,
      0.149592,
      2.694092,
      1.210093,
      3,
      1,
      NULL);
commit;
end;
/


