set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9750213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '302',
      '23302332',
      NULL,
      52,
      '2012040',
      54,
      5,
      1,
      NULL,
      '322143',
      5.583588,
      ' 1- 8-1981',
      NULL,
      32.169307,
      0,
      NULL,
      1.134226,
      NULL,
      0.651842,
      0,
      NULL,
      3.544934,
      1.372458,
      0.233787,
      1,
      NULL,
      5,
      0,
      0.972623,
      3,
      1.368052,
      0,
      9.793303,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.386540,
      3,
      0.233653,
      1.590257,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.667408,
      NULL,
      NULL,
      2.339352,
      0.619458,
      1.217765,
      1.938089,
      3.051791,
      NULL,
      NULL,
      2.852414,
      0.976555,
      1,
      1.070082,
      1.079468,
      1.152479,
      3.342696,
      3.902449,
      2.213224,
      NULL,
      1,
      2,
      6,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      0.804017,
      NULL,
      NULL,
      0,
      1.774854,
      3.287554,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749013,
      0,
      0.643409,
      1,
      1.129082,
      1.011555,
      5.003299,
      0,
      0,
      0.683615,
      0,
      NULL,
      NULL,
      1,
      5.334182,
      NULL,
      NULL,
      8.962003,
      0,
      0,
      0,
      NULL,
      1.627304,
      4.195707,
      1,
      3,
      0.448299,
      NULL,
      NULL,
      NULL,
      2.627195,
      5,
      NULL,
      NULL,
      11,
      2.312333,
      11.950993,
      NULL,
      0.898896,
      NULL,
      1,
      2.030557,
      0,
      NULL,
      4.419973,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1.522583,
      0.676066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.159893,
      0,
      2.590266,
      NULL,
      2.132579,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0,
      5,
      6,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.884520,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.778960,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.464712,
      NULL,
      1,
      1,
      0,
      0,
      0.539204,
      NULL,
      0.673791,
      1.650558,
      1.838081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      7.349971,
      NULL,
      2,
      1,
      2,
      3,
      1,
      3,
      1.065221);
commit;
end;
/


