set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9750213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '432',
      '01032203',
      46,
      11.255258,
      '2402242',
      38,
      1,
      NULL,
      NULL,
      '020102',
      1.389421,
      ' 8-28-1989',
      10.665332,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0.216954,
      0.172231,
      NULL,
      NULL,
      2,
      NULL,
      0.299326,
      NULL,
      NULL,
      0.850846,
      NULL,
      NULL,
      1.566426,
      0,
      1.344716,
      1,
      0.779046,
      0,
      1.093706,
      3.487957,
      0.419114,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408417,
      4.668051,
      1.461215,
      1.618577,
      1.567355,
      3.884476,
      3,
      0.125995,
      1.121447,
      0.400453,
      1,
      0,
      0,
      0.386627,
      2.828404,
      1,
      1.321332,
      2.263131,
      1,
      0.621609,
      2.512012,
      5,
      0,
      NULL,
      0,
      0.726033,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.672835,
      NULL,
      1.975351,
      1.475542,
      1,
      3,
      NULL,
      NULL,
      0.841709,
      0,
      1.789849,
      NULL,
      0,
      2.875410,
      0.080532,
      0,
      0.091256,
      0,
      0.265943,
      NULL,
      1,
      NULL,
      5.757525,
      4,
      5,
      NULL,
      0,
      0,
      4.643814,
      1.913582,
      5.783038,
      1,
      3.342676,
      0.171741,
      NULL,
      3,
      5,
      NULL,
      2,
      4.728277,
      NULL,
      7.543792,
      NULL,
      7.724481,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.479767,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.286501,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.177982,
      0.606666,
      NULL,
      NULL,
      NULL,
      1.113839,
      NULL,
      4.460731,
      1,
      1.140679,
      2,
      1.767839,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.434370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      1.391256,
      2,
      2.170348,
      0.378614,
      1.150994,
      0,
      1,
      0.417777,
      1,
      NULL,
      1.620223,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '12000',
      NULL,
      '',
      1.137059,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.463608,
      NULL,
      3.986399,
      1.097171,
      1.896230,
      0,
      3,
      3,
      2.404544);
commit;
end;
/


