set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9710835';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '334',
      NULL,
      34,
      39,
      '0431201',
      4,
      6,
      NULL,
      NULL,
      '224032',
      NULL,
      '11-19-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.895595,
      0,
      NULL,
      0,
      0.712610,
      1,
      2.249892,
      NULL,
      0.656342,
      0.444276,
      0.249255,
      NULL,
      NULL,
      1.752314,
      0.475741,
      0.535406,
      NULL,
      0.898218,
      1,
      1,
      4.923786,
      1,
      0.001765,
      1.900446,
      NULL,
      NULL,
      0.771310,
      NULL,
      NULL,
      0.565838,
      1,
      0.586088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.517009,
      1,
      2,
      0.828600,
      0.100959,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.108028,
      1,
      1.736991,
      0,
      0,
      0,
      NULL,
      1.091941,
      1.788317,
      0.040193,
      0,
      NULL,
      NULL,
      1,
      1,
      0.330863,
      NULL,
      NULL,
      NULL,
      0,
      0.496205,
      1.805621,
      NULL,
      2.788403,
      0,
      5.219198,
      3.443893,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.086598,
      NULL,
      4,
      4.208918,
      4,
      4.019219,
      3,
      2,
      NULL,
      7.207746,
      NULL,
      2.606689,
      1.594792,
      1,
      NULL,
      1.706875,
      NULL,
      NULL,
      8,
      0.405396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.632986,
      1.011192,
      0,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.837667,
      1,
      3,
      0.596342,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.445320,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.763793,
      2,
      NULL,
      0,
      0.524953,
      1,
      0,
      NULL,
      3.598937,
      0,
      0,
      NULL,
      0,
      1.481947,
      0,
      0,
      0.911098,
      1.714086,
      1.841876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.918905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22124',
      '',
      '',
      0.121848,
      '',
      '',
      '',
      0.511889,
      '',
      NULL,
      '',
      4,
      3.767499,
      NULL,
      NULL,
      0,
      0.621497,
      NULL,
      0.592461,
      0.223953);
commit;
end;
/


