set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9710835';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '132',
      '21403200',
      21,
      NULL,
      '3410034',
      16,
      6,
      2,
      2,
      '314322',
      4.082854,
      NULL,
      126.656979,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.092890,
      1,
      1.920818,
      0.191883,
      NULL,
      1.740919,
      1.665205,
      0,
      0,
      0,
      0,
      NULL,
      1,
      6.853441,
      1,
      NULL,
      NULL,
      0,
      0,
      1.306523,
      0,
      1,
      2,
      1,
      0.715879,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.070990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.122117,
      NULL,
      1.627623,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      0.765496,
      NULL,
      NULL,
      0,
      NULL,
      1.797932,
      NULL,
      NULL,
      1,
      3,
      1,
      1.600534,
      2.653390,
      1.463641,
      NULL,
      0.880536,
      1.458745,
      1,
      0.124316,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.532805,
      2.008777,
      0,
      1.229969,
      0.571600,
      6,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053699,
      4.811605,
      0.676598,
      3,
      1,
      1,
      NULL,
      7,
      2.689505,
      0,
      NULL,
      5.302219,
      4.339503,
      1.963933,
      0,
      0.438069,
      3.220773,
      0.260399,
      NULL,
      0.919155,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019984,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594484,
      NULL,
      6,
      1.533461,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.498553,
      1.138451,
      2,
      0.872178,
      1,
      0.989114,
      NULL,
      NULL,
      NULL,
      0,
      1.762571,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.739016,
      0.744936,
      2,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0.737633,
      0,
      1,
      0,
      NULL,
      1,
      1.276231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.514839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.243450,
      '13211',
      '',
      '',
      0.305916,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      5,
      NULL,
      3,
      3.074772,
      1,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


