set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '321',
      '11',
      NULL,
      NULL,
      '1002014',
      NULL,
      2,
      0.878683,
      NULL,
      '240311',
      NULL,
      ' 7- 8-2002',
      19,
      46.640990,
      1.951276,
      NULL,
      2.217121,
      0,
      0,
      0.855167,
      1,
      0.708347,
      3,
      0,
      1.861251,
      NULL,
      NULL,
      NULL,
      1.631311,
      1,
      NULL,
      0,
      NULL,
      0.057561,
      1.559842,
      0,
      0,
      1.336350,
      0.654539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.171562,
      NULL,
      1.898125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.122223,
      1,
      1,
      1.042895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998935,
      4,
      4.066157,
      0,
      3.025143,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0.552110,
      1,
      0.870621,
      1.133942,
      1.094072,
      0.622205,
      NULL,
      0,
      NULL,
      0.467076,
      NULL,
      0.050902,
      0,
      1,
      0,
      5.444554,
      NULL,
      5.753321,
      3,
      0.877987,
      1,
      1,
      1.260640,
      2.108363,
      1,
      2.725973,
      NULL,
      3,
      2.570511,
      1.455588,
      0,
      5,
      4.842508,
      NULL,
      NULL,
      3,
      7,
      0.368683,
      NULL,
      NULL,
      0.178626,
      0.438640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.468830,
      0,
      1,
      0,
      NULL,
      0.570122,
      NULL,
      0.994237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.309317,
      0.503732,
      NULL,
      4.496136,
      8.307409,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      4.724938,
      4.984606,
      1,
      1,
      0.537649,
      NULL,
      NULL,
      NULL,
      0,
      7.465971,
      1.178911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.157349,
      1.585378,
      1.875476,
      NULL,
      1.163333,
      2.356269,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0.468532,
      0.418895,
      0.689607,
      0.608816,
      1,
      1.356327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.304372,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.444345,
      1,
      NULL,
      0.211676,
      1.072471,
      1.218131,
      2,
      1.556336,
      '13014',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '13123',
      '',
      '',
      0.376371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


