set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02',
      19,
      NULL,
      '4234334',
      12.812876,
      0,
      3.927838,
      0,
      '431010',
      2,
      '11-22-1989',
      NULL,
      NULL,
      1.291859,
      NULL,
      2,
      NULL,
      0,
      0,
      2.428981,
      NULL,
      3,
      1,
      0.025094,
      1.822744,
      NULL,
      1.791787,
      0.286812,
      1.734909,
      0,
      1,
      NULL,
      0.049932,
      0.331889,
      1.389740,
      1.145400,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0.945987,
      NULL,
      1.785274,
      0.744121,
      3.589673,
      1,
      NULL,
      3.755694,
      0,
      3,
      1,
      NULL,
      3,
      2.285243,
      NULL,
      1,
      1,
      1,
      0,
      1,
      3.196120,
      1,
      NULL,
      1,
      0.538932,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.743448,
      1,
      5.696664,
      1,
      0.723251,
      0.023763,
      NULL,
      NULL,
      1.393773,
      0.644311,
      1.821874,
      NULL,
      0.218144,
      0,
      NULL,
      1,
      0.278311,
      NULL,
      1.787205,
      NULL,
      0,
      1.313409,
      NULL,
      NULL,
      4,
      NULL,
      3.362186,
      0.330785,
      2.205733,
      7.629780,
      2,
      0,
      4,
      0.927466,
      7.402203,
      5,
      NULL,
      11,
      9.992119,
      5.091759,
      5.642360,
      10.592507,
      4,
      6,
      NULL,
      7.486023,
      2,
      1.188864,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.644340,
      1,
      NULL,
      NULL,
      3.735997,
      NULL,
      0,
      1,
      NULL,
      1.491849,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2,
      5.450451,
      NULL,
      0.676608,
      NULL,
      5.642271,
      1.279761,
      NULL,
      NULL,
      NULL,
      0.892572,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002830,
      1.045957,
      3,
      1.915406,
      3.710249,
      3,
      1,
      2,
      3,
      2.985340,
      1.524296,
      1,
      0,
      1,
      0.822759,
      1,
      NULL,
      0,
      0.034505,
      0.652449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.516734,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1.579404,
      0,
      2,
      3,
      '00200',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      3.269664,
      7,
      0.901587,
      2,
      1.756835,
      2.932579,
      3.980061,
      0.610303,
      3);
commit;
end;
/


