set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      '33034442',
      9,
      10,
      NULL,
      NULL,
      4,
      1,
      NULL,
      '210101',
      5,
      ' 2-14-1982',
      30.791440,
      29,
      NULL,
      NULL,
      0,
      0,
      1.010623,
      1.593659,
      NULL,
      0.175762,
      0.455936,
      NULL,
      0,
      1,
      NULL,
      0,
      0.135453,
      1,
      1,
      1,
      NULL,
      0.806359,
      1,
      0.631667,
      NULL,
      1,
      1.131074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.166300,
      1,
      NULL,
      1.387776,
      0.200887,
      NULL,
      3,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0.114957,
      3.556814,
      1.853354,
      NULL,
      NULL,
      1,
      0.058487,
      1.212240,
      0.289942,
      3.784036,
      0,
      1,
      1.853969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.581087,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.471073,
      1,
      1.000791,
      1,
      0,
      1.450880,
      0.762922,
      NULL,
      1,
      NULL,
      0.938002,
      0,
      0.271055,
      NULL,
      NULL,
      4,
      1.769834,
      0,
      1.129877,
      NULL,
      0.997173,
      1,
      2.379907,
      0,
      5,
      0.618072,
      NULL,
      0.743393,
      5.240274,
      5,
      NULL,
      1,
      3.901837,
      7,
      6.797206,
      1,
      0,
      1,
      NULL,
      4.416389,
      8,
      6,
      0.232124,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0.955082,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.479556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081348,
      1.780956,
      5,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.919574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.681539,
      1,
      0.883042,
      1.097445,
      1.879290,
      0.149943,
      1,
      2.563585,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1.135321,
      0.036569,
      1.368137,
      0.762163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.109312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471121,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911532,
      NULL,
      NULL,
      NULL,
      NULL,
      3.014244,
      0,
      0.064620,
      NULL,
      NULL,
      1,
      0.957823,
      2,
      NULL,
      '34242',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0.688392,
      '24244',
      '',
      NULL,
      1.044384,
      4,
      NULL,
      3.347627,
      0,
      1,
      1.941855,
      2.414059,
      0.046915);
commit;
end;
/


