set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '310',
      '20001142',
      1.940586,
      NULL,
      '3240420',
      19.137215,
      NULL,
      NULL,
      2,
      '303442',
      1,
      '10- 0-1976',
      53.241129,
      31,
      0,
      NULL,
      1.515661,
      1.772819,
      1.226604,
      NULL,
      0.859951,
      1.150281,
      NULL,
      1.316767,
      1,
      1.760218,
      1.537059,
      NULL,
      1.312130,
      1.964026,
      1,
      1,
      0,
      1.215337,
      1.010959,
      0,
      0.766495,
      1.221750,
      0.682427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192949,
      1,
      0.716078,
      1.057229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.518014,
      1,
      NULL,
      0.622558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.046831,
      4,
      NULL,
      4.896896,
      0,
      0,
      0,
      1.833639,
      0.270105,
      0.684211,
      0,
      0,
      0,
      0.647717,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      4.129741,
      0,
      NULL,
      0,
      4,
      NULL,
      1.317210,
      NULL,
      NULL,
      2.177371,
      3.267429,
      3.248120,
      5,
      6,
      0,
      3.757610,
      NULL,
      1.688805,
      0,
      0.017415,
      1,
      6,
      0.420493,
      NULL,
      NULL,
      4,
      0.788342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.851545,
      0.976587,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.717411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.788271,
      3.997944,
      1,
      NULL,
      NULL,
      NULL,
      0.293250,
      1,
      2.274389,
      0,
      0.621132,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.596658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0.372776,
      3,
      1.627941,
      2.550588,
      1,
      3.313073,
      3.435614,
      1.673974,
      0,
      1.573929,
      0.408642,
      1,
      1.083040,
      1.794000,
      1,
      0.698460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185759,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830791,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.538118,
      1,
      1.037440,
      1,
      3,
      '20414',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.785188,
      '',
      '',
      NULL,
      0.738637,
      2.606950,
      2.146367,
      1,
      3,
      1,
      NULL,
      1,
      0.927210);
commit;
end;
/


