set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40014100',
      NULL,
      17,
      '3304420',
      55.442934,
      1,
      1,
      1,
      '114420',
      5.590046,
      ' 6- 8-1986',
      NULL,
      28,
      NULL,
      NULL,
      1.245506,
      0,
      0,
      1.137850,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.286853,
      1.734954,
      1.574683,
      NULL,
      3.253581,
      0,
      NULL,
      1,
      3.001629,
      1.253781,
      1.065682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760125,
      0,
      1,
      0.981840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.927315,
      4.225165,
      NULL,
      NULL,
      1,
      1.622667,
      0.072655,
      NULL,
      NULL,
      0.166908,
      NULL,
      NULL,
      0.963914,
      5,
      2.299158,
      0,
      4,
      1.761048,
      0.673342,
      0.879909,
      NULL,
      0,
      1.562094,
      1.173872,
      1.143750,
      0.325074,
      0.437212,
      1,
      0,
      1.557215,
      1.531771,
      NULL,
      0,
      6.677502,
      NULL,
      0,
      1,
      1,
      2,
      0.745779,
      2.241850,
      4,
      5.069616,
      2.087114,
      3,
      NULL,
      4.420899,
      1,
      1,
      2,
      2.735939,
      1,
      5.059464,
      NULL,
      2,
      6.288421,
      5.918093,
      4,
      7.386804,
      1.145737,
      0.004511,
      0.775195,
      0.795436,
      NULL,
      0.416695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.357254,
      NULL,
      NULL,
      1,
      1,
      1.592875,
      NULL,
      0.212877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.808495,
      3,
      0,
      NULL,
      NULL,
      NULL,
      5.971295,
      2.990420,
      6.473555,
      NULL,
      0.384929,
      NULL,
      5.539494,
      1.501808,
      NULL,
      NULL,
      NULL,
      4.865076,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.473613,
      3.439728,
      1,
      0,
      3.049585,
      1.778528,
      2.455416,
      2,
      0,
      NULL,
      2,
      0.592001,
      0.962724,
      1.557253,
      1.506529,
      NULL,
      1.649945,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '32033',
      '',
      '',
      0.933873,
      '',
      NULL,
      NULL,
      NULL,
      '4420',
      '',
      '',
      3.285399,
      0,
      3,
      NULL,
      5,
      0,
      1.289502,
      NULL,
      NULL);
commit;
end;
/


