set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      '01234044',
      44.399365,
      29,
      '3300101',
      NULL,
      5,
      0,
      2,
      '311403',
      0.359338,
      ' 1-17-1998',
      2.047338,
      58.099569,
      0.512901,
      NULL,
      1,
      3,
      0,
      0,
      NULL,
      1.052227,
      1.560498,
      1,
      0.439388,
      1.449836,
      0.849139,
      1,
      0.707959,
      0.406683,
      0,
      1,
      0.601139,
      0.099681,
      0,
      1.239464,
      0.726743,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.728648,
      1.563395,
      1.555930,
      0.817014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881138,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978418,
      1,
      1.375158,
      NULL,
      NULL,
      0.177561,
      1.961611,
      NULL,
      0.780520,
      NULL,
      0.435787,
      0,
      1.940070,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.982849,
      6.013121,
      1.420644,
      0,
      1,
      1.379919,
      4,
      0,
      NULL,
      5,
      3,
      2,
      0.798116,
      0,
      5,
      1.981343,
      2,
      0.325356,
      9,
      8,
      2.394304,
      NULL,
      NULL,
      3,
      5,
      5.995663,
      3,
      2,
      0.097913,
      NULL,
      NULL,
      3,
      0.407373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.956461,
      0,
      1,
      1,
      NULL,
      1.958274,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112051,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.573909,
      NULL,
      0.580861,
      NULL,
      NULL,
      NULL,
      1.310736,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0.828005,
      NULL,
      NULL,
      NULL,
      1.766235,
      4.186982,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.119556,
      0.695839,
      1,
      1.272956,
      NULL,
      1,
      3,
      1.547068,
      3.059080,
      NULL,
      1,
      1.504325,
      1.468660,
      1,
      0.008546,
      1,
      0,
      1.466905,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '04320',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '2230',
      '',
      NULL,
      4.781462,
      NULL,
      NULL,
      NULL,
      1.182503,
      2.324519,
      0,
      3,
      2.079129);
commit;
end;
/


