set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04434441',
      NULL,
      71,
      '0300411',
      107,
      3,
      NULL,
      0,
      '310202',
      4.735136,
      ' 3- 6-1994',
      45,
      43.827052,
      NULL,
      NULL,
      2.359248,
      NULL,
      0.494089,
      1.801845,
      3,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1.645086,
      0,
      0,
      1.090276,
      1,
      1.442424,
      0,
      1,
      0,
      0.474654,
      0.386390,
      1.602680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625368,
      0.472727,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.527850,
      4.523222,
      5.533369,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.020145,
      0,
      0.831724,
      5.561056,
      NULL,
      NULL,
      1,
      0.935105,
      0,
      1.267397,
      0,
      0.885802,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      2,
      1,
      1.242475,
      3.536715,
      0,
      0,
      1,
      5,
      2,
      3,
      7.343203,
      NULL,
      1,
      2,
      1.831242,
      2,
      2.656510,
      9,
      6,
      7.630868,
      0.619657,
      1.208904,
      4.213231,
      4,
      5,
      1,
      1,
      0.926670,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.865474,
      0.582977,
      1,
      NULL,
      1.873683,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.031983,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.737252,
      3.739177,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.225698,
      0.773573,
      NULL,
      NULL,
      2,
      0.225306,
      NULL,
      NULL,
      NULL,
      0,
      0.869314,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072821,
      1,
      1,
      1,
      2.975839,
      1.079350,
      1,
      NULL,
      1,
      2.633568,
      0.882054,
      1.789791,
      1,
      1.252796,
      NULL,
      1,
      0.224989,
      NULL,
      0.510621,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.351659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.614185,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822378,
      0,
      1.197681,
      NULL,
      0.769081,
      1.064224,
      1,
      2,
      2,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '3003',
      '',
      NULL,
      2.548737,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      2.540713,
      0,
      NULL);
commit;
end;
/


