set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23044044',
      NULL,
      21,
      NULL,
      0,
      2,
      NULL,
      NULL,
      '123234',
      NULL,
      ' 9-14-1986',
      24.733800,
      24.904221,
      NULL,
      NULL,
      0,
      3.806861,
      NULL,
      1.916361,
      NULL,
      1.625012,
      3,
      1,
      1.392590,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      1.696426,
      1.709254,
      1.385734,
      1,
      0,
      1,
      NULL,
      1.529681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.162152,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828522,
      NULL,
      3.004998,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.319471,
      4,
      1.934926,
      1.458316,
      NULL,
      0,
      0.603850,
      1.764114,
      1,
      0.909485,
      1,
      1,
      1.132548,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.844435,
      0,
      1,
      1.485722,
      1.438860,
      3.931395,
      1,
      1,
      0.052565,
      2,
      7.750905,
      2.882490,
      0.268165,
      NULL,
      0.230588,
      1.324137,
      0.957220,
      1.466236,
      7.418564,
      NULL,
      1,
      NULL,
      1.447418,
      1.673201,
      0.681223,
      4,
      1.607246,
      1.777705,
      NULL,
      NULL,
      0.254946,
      0.476006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266357,
      NULL,
      1,
      0,
      1.371339,
      NULL,
      2.416792,
      0.547171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.135108,
      NULL,
      NULL,
      NULL,
      NULL,
      0.777718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      0.768602,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.331206,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693189,
      0.893974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.960351,
      1.244836,
      1,
      NULL,
      3,
      3.363371,
      1,
      0,
      1,
      0.210017,
      3,
      NULL,
      0.549614,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.882451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.358695,
      1.888268,
      NULL,
      NULL,
      1.078812,
      0,
      NULL,
      0.113187,
      '41244',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '3202',
      NULL,
      '',
      3.378501,
      4.270183,
      NULL,
      3.606354,
      NULL,
      3.388206,
      0,
      0.756012,
      1);
commit;
end;
/


