set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1403',
      '02211104',
      31,
      NULL,
      '4210344',
      13.925666,
      5,
      1.725020,
      NULL,
      '033431',
      4.791290,
      ' 9-13-1991',
      32.467687,
      7.416635,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      0,
      2.462900,
      0.839228,
      0.591159,
      1.592983,
      NULL,
      1,
      0,
      0.852076,
      0.704365,
      NULL,
      0,
      NULL,
      0,
      0.674468,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.265433,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.587996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.088407,
      3,
      NULL,
      0.397508,
      0.666300,
      1.401122,
      0.972768,
      NULL,
      1,
      1,
      0.213544,
      1.325758,
      1,
      1.943488,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.232046,
      0,
      0,
      1,
      0,
      5.635856,
      1,
      1,
      5.593895,
      7,
      1.495988,
      NULL,
      1,
      4.661808,
      1.753945,
      4,
      0,
      7,
      NULL,
      6.067814,
      NULL,
      1,
      NULL,
      3.086382,
      3,
      0,
      NULL,
      0.597052,
      NULL,
      NULL,
      1.593047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.227169,
      NULL,
      2,
      1,
      1.914914,
      1,
      3.372589,
      0.007553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.045908,
      0.523673,
      1.568531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.521913,
      0,
      1,
      1.495889,
      NULL,
      NULL,
      NULL,
      1.321771,
      0,
      0.259593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.054012,
      2,
      1,
      NULL,
      1.426239,
      0.691608,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.497854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.056624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365692,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416219,
      0,
      1.700455,
      NULL,
      1.541421,
      NULL,
      0,
      0,
      0.209867,
      '20323',
      '',
      '',
      0,
      '',
      '',
      '',
      0.907697,
      NULL,
      '',
      '',
      NULL,
      3.404490,
      NULL,
      1.052681,
      2.644404,
      NULL,
      1.296843,
      2.401595,
      2);
commit;
end;
/


