set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4021',
      NULL,
      NULL,
      64,
      '3213043',
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      '10-16-1975',
      53,
      32.454191,
      0.609595,
      NULL,
      1.098967,
      1.574537,
      0,
      1,
      1.109260,
      1,
      1,
      1.391394,
      1.640992,
      1,
      0.542659,
      0,
      0,
      1.255580,
      1.614441,
      0.481193,
      NULL,
      1,
      0.938012,
      1,
      1.679404,
      1.976100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191018,
      0.182368,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130697,
      3.609619,
      5,
      0,
      1,
      0.219680,
      0.902902,
      NULL,
      NULL,
      1.299034,
      NULL,
      NULL,
      0.404936,
      3.898181,
      NULL,
      NULL,
      0.599141,
      NULL,
      1,
      1,
      NULL,
      1.497727,
      0,
      NULL,
      1.363473,
      0,
      NULL,
      0.089216,
      1,
      NULL,
      1.844227,
      NULL,
      1.124824,
      2,
      1.906259,
      1,
      1,
      1,
      3.711633,
      NULL,
      0.081813,
      NULL,
      0.283190,
      3,
      NULL,
      1.080515,
      3,
      0,
      4,
      2.390579,
      4.035881,
      3.279624,
      0.793018,
      3,
      NULL,
      3.603910,
      1,
      4.572696,
      NULL,
      0.807028,
      0,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.726121,
      0.072013,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.145198,
      1.495485,
      4,
      1,
      1.124745,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.355448,
      NULL,
      1.088403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.442382,
      0.036176,
      NULL,
      2.862794,
      1.916772,
      2.934496,
      0.113930,
      NULL,
      2.863103,
      0.415543,
      1.953833,
      1.502842,
      1,
      1,
      1,
      1.892662,
      1.156624,
      0.323519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '33311',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      NULL,
      '',
      NULL,
      4.433457,
      0.564139,
      NULL,
      5.690856,
      NULL,
      NULL,
      0,
      NULL,
      3.913709);
commit;
end;
/


