set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '1241222',
      81,
      6,
      3.088530,
      2,
      '022203',
      4.535170,
      ' 4- 9-1991',
      NULL,
      23.036021,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0.549760,
      3,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      0.464367,
      0.399207,
      1.998817,
      0,
      0,
      1.908623,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732120,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.783639,
      4.720410,
      2.393899,
      NULL,
      1,
      NULL,
      0.014977,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.900453,
      NULL,
      0.490388,
      NULL,
      5,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      1.807578,
      NULL,
      NULL,
      1,
      7.096623,
      0,
      NULL,
      NULL,
      0,
      7.195783,
      NULL,
      NULL,
      1,
      5.881244,
      4.344638,
      1.479678,
      NULL,
      5.742055,
      1,
      NULL,
      NULL,
      1.001586,
      7.238324,
      3.540757,
      2,
      3.766861,
      5.387123,
      NULL,
      3.835878,
      5.319494,
      2.770555,
      1,
      NULL,
      NULL,
      4.427517,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649378,
      NULL,
      2,
      0,
      NULL,
      0.563224,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.285701,
      NULL,
      NULL,
      NULL,
      NULL,
      1.984754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.650912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.483176,
      NULL,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.710380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072113,
      1.466472,
      NULL,
      0.617312,
      0.063752,
      1.074261,
      0,
      1.752397,
      1,
      0,
      0,
      0,
      0,
      0.714731,
      NULL,
      0,
      0,
      1,
      1.388760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '13322',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '14120',
      '41223',
      '',
      2,
      0.258822,
      1,
      2.593745,
      2.725459,
      1.487097,
      NULL,
      1.930178,
      3);
commit;
end;
/


