set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1322',
      '00020342',
      50.380276,
      69,
      '4003211',
      113,
      0,
      1.985578,
      3,
      '142341',
      1,
      NULL,
      13.249778,
      36.533248,
      0,
      NULL,
      1.077468,
      0.690166,
      1,
      1.852868,
      1,
      NULL,
      3.993663,
      0,
      0,
      0.789485,
      1,
      1,
      NULL,
      0,
      0,
      1,
      5.870490,
      0.930052,
      1.659309,
      1.745047,
      0.486795,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.531119,
      0.570408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.077811,
      NULL,
      2,
      0,
      NULL,
      0.568229,
      0.235833,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.743006,
      0.050226,
      1.918623,
      NULL,
      1,
      NULL,
      1,
      1,
      0.759475,
      1.414577,
      0.357007,
      NULL,
      0,
      0,
      0,
      0.935830,
      0,
      NULL,
      0.908057,
      2,
      0,
      1,
      0.290439,
      1,
      3,
      1.430452,
      2,
      1.803673,
      3.120977,
      1.772675,
      1,
      1,
      2.883864,
      1,
      4.252451,
      2,
      6.863555,
      2.844890,
      1.495179,
      0,
      2,
      2,
      5.236732,
      1.860957,
      6.893190,
      3.309460,
      0,
      NULL,
      NULL,
      9.503594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.250749,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      0.273033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717631,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.303099,
      1.862114,
      1.438280,
      3.930027,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.439164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.187927,
      0.091758,
      1,
      3.378733,
      0,
      0.405959,
      0.084423,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0.177050,
      NULL,
      0.732239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '44243',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '40443',
      '02440',
      '',
      3,
      4,
      0,
      NULL,
      1,
      2.720989,
      0,
      3.159810,
      0);
commit;
end;
/


