set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9689561';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3212',
      '13302433',
      10.660908,
      34.860272,
      '3223122',
      20,
      1,
      NULL,
      0,
      '141233',
      2,
      '11-15-1994',
      41.034397,
      14.267529,
      0.114107,
      NULL,
      1.868672,
      2.585237,
      1.452655,
      1,
      1.889266,
      1.321327,
      1.099600,
      NULL,
      0,
      0,
      0.145563,
      1.671357,
      1,
      0,
      1,
      NULL,
      1.600776,
      1,
      0.889221,
      NULL,
      0.453740,
      0.710331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.181185,
      0.989058,
      0,
      1.302143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.145636,
      NULL,
      NULL,
      0.994677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.803497,
      0.613282,
      0,
      NULL,
      1.876863,
      0,
      1.329166,
      1,
      1.669533,
      0.645551,
      1.003224,
      0.216390,
      NULL,
      NULL,
      1.399171,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0.758317,
      0.280810,
      0.613536,
      0.141962,
      0,
      NULL,
      0.902569,
      0.421052,
      0,
      1.274879,
      NULL,
      1.314084,
      NULL,
      NULL,
      0.519279,
      4,
      1,
      4,
      NULL,
      1.095351,
      0,
      1.046948,
      NULL,
      NULL,
      0.771793,
      NULL,
      1,
      NULL,
      NULL,
      8.198176,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.754216,
      0.316934,
      0,
      1,
      NULL,
      1.103665,
      0.896126,
      1.285376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.737881,
      3,
      1.342484,
      NULL,
      1,
      2.288472,
      1.300935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509424,
      NULL,
      1,
      4.100144,
      0,
      1,
      0.596824,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.451125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1.662988,
      NULL,
      1,
      0.368072,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '23214',
      '',
      '',
      0,
      '',
      '',
      '',
      4.579332,
      '3034',
      '2010',
      '',
      1.118046,
      3.087309,
      2.459815,
      5.487160,
      0,
      2.335230,
      3.189929,
      NULL,
      2);
commit;
end;
/


