set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '200',
      '01',
      19.898616,
      14.353438,
      '0013210',
      8.822962,
      6,
      2.803900,
      3,
      '110301',
      0.284301,
      NULL,
      NULL,
      26,
      0,
      NULL,
      NULL,
      NULL,
      1.127582,
      NULL,
      0.330280,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1.474958,
      NULL,
      0.192101,
      0,
      2,
      NULL,
      NULL,
      2,
      3.293432,
      NULL,
      8,
      1,
      1.047623,
      1,
      2.851819,
      0,
      NULL,
      NULL,
      0.059032,
      NULL,
      NULL,
      4.955973,
      2,
      2.767795,
      3.180374,
      1.606382,
      NULL,
      3.720990,
      2,
      0.100341,
      NULL,
      0.372213,
      NULL,
      NULL,
      NULL,
      NULL,
      1.556810,
      NULL,
      NULL,
      0.252847,
      0,
      0.924395,
      2,
      6.726161,
      0,
      1,
      1.425508,
      0,
      NULL,
      NULL,
      0.594470,
      NULL,
      NULL,
      1,
      5.072049,
      2.523100,
      1.923272,
      NULL,
      1,
      0,
      1.580694,
      1.076414,
      1,
      NULL,
      1,
      1.966656,
      1,
      0,
      1.241753,
      0,
      1.805567,
      0,
      NULL,
      0,
      NULL,
      0.496626,
      1.822428,
      0.798806,
      1.346170,
      2,
      1,
      6.965571,
      0,
      0.676852,
      5,
      2,
      1,
      7,
      0.836679,
      NULL,
      0.684571,
      4.455850,
      7,
      0,
      4,
      2.343155,
      2.623482,
      NULL,
      0,
      0.843781,
      0,
      0.918786,
      0.176087,
      0.502536,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.724825,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.431924,
      NULL,
      6.603091,
      NULL,
      3.939929,
      3.782030,
      NULL,
      0.655820,
      1.191309,
      NULL,
      0.874160,
      8.120606,
      0.973294,
      1.025882,
      1.587361,
      NULL,
      NULL,
      NULL,
      0.796417,
      5.276249,
      1.478366,
      NULL,
      0,
      5,
      0.380910,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.600087,
      2.807148,
      3.652637,
      0.269645,
      2,
      3,
      2.488458,
      0.178526,
      NULL,
      1,
      0.022868,
      1,
      0.335986,
      1,
      1.124362,
      0.287553,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.948650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.725444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.028783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.042431,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1.186554,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.147009,
      0,
      0,
      NULL,
      0,
      NULL,
      1.597701,
      2,
      2,
      '01042',
      '',
      NULL,
      1.956312,
      '',
      NULL,
      '',
      0.996785,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


