set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21',
      NULL,
      9.078460,
      NULL,
      21.176409,
      3,
      1,
      2,
      '041441',
      NULL,
      NULL,
      48,
      3,
      0,
      NULL,
      1,
      0,
      0.058185,
      NULL,
      0,
      NULL,
      0.797837,
      1.566658,
      1,
      0.564869,
      NULL,
      1.418087,
      1.024534,
      NULL,
      0,
      4.453816,
      3,
      5,
      2.387627,
      1,
      3.837591,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3,
      0.766204,
      NULL,
      NULL,
      1.764431,
      NULL,
      NULL,
      0,
      NULL,
      0.636703,
      1.727372,
      1.889057,
      0.911466,
      3.780674,
      NULL,
      0.559562,
      3.344286,
      NULL,
      1,
      1.751101,
      1.889035,
      0.684252,
      0.226191,
      0,
      NULL,
      0.477048,
      1,
      0.509110,
      NULL,
      3,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.366657,
      6,
      1,
      3.217098,
      NULL,
      1.989824,
      1,
      0.194677,
      1.488715,
      NULL,
      NULL,
      0.564922,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.813556,
      1.477755,
      1,
      1.576761,
      NULL,
      0,
      NULL,
      1.257063,
      1,
      2,
      5,
      1.647787,
      2,
      1,
      0.893348,
      4,
      3,
      6,
      2,
      0,
      4,
      3.255670,
      1,
      3.307996,
      1.510109,
      4,
      0,
      0,
      1,
      3.205514,
      1.060996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      1.102073,
      0.126593,
      0.103961,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.703452,
      NULL,
      NULL,
      2.668456,
      3,
      2.798752,
      1,
      1,
      1,
      0.796411,
      0,
      NULL,
      0,
      0.886040,
      2.841893,
      1.629921,
      1.657519,
      3,
      0.767498,
      1,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      2,
      1,
      1.658328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.730341,
      0,
      1,
      3.575810,
      0.080819,
      NULL,
      1,
      1,
      2.398253,
      1,
      NULL,
      NULL,
      1,
      1.055897,
      0.146416,
      3.109843,
      1,
      1,
      0,
      1.450047,
      2.883228,
      3.112876,
      1.838170,
      0.704377,
      0,
      1,
      0.862937,
      1,
      0.357393,
      1.620700,
      0.970856,
      1.638275,
      1.983783,
      1.431172,
      1,
      1,
      1,
      1.338118,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.380412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.320110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830670,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.562398,
      3.153169,
      3.709674,
      NULL,
      1.552700,
      1.350486,
      2,
      4,
      '12232',
      '42430',
      '41014',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      2.841250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


