set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '302',
      '12',
      21.118443,
      10,
      NULL,
      17,
      4,
      3,
      2,
      '202102',
      5,
      ' 1- 4-1988',
      48.769401,
      63.075157,
      0,
      NULL,
      3,
      NULL,
      1.164444,
      NULL,
      2,
      0.655506,
      0.028517,
      NULL,
      NULL,
      NULL,
      7.583165,
      1,
      NULL,
      1.576073,
      NULL,
      0.490164,
      NULL,
      NULL,
      3,
      0,
      0.223264,
      3,
      3,
      1,
      NULL,
      NULL,
      3.346574,
      0,
      NULL,
      NULL,
      1.897690,
      NULL,
      NULL,
      1.962175,
      3,
      1.367363,
      2.543561,
      0.910949,
      1,
      0,
      3,
      NULL,
      3,
      1.362866,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.123764,
      0,
      0,
      0,
      0,
      7,
      0,
      NULL,
      0.338531,
      1.444520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.104079,
      2,
      NULL,
      5.186745,
      0,
      0.991508,
      1,
      0.526443,
      NULL,
      0.474031,
      1.682513,
      0.182251,
      0.354205,
      NULL,
      0,
      1.380708,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      0.435652,
      0,
      NULL,
      0.081615,
      NULL,
      3.968161,
      0,
      NULL,
      7.764485,
      0,
      NULL,
      0,
      0,
      NULL,
      5.434436,
      0,
      NULL,
      4.355504,
      7.239100,
      5.051666,
      5,
      4.352176,
      2.708536,
      NULL,
      3,
      2,
      1,
      1.590778,
      1.772427,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0.370737,
      NULL,
      1.078635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.006959,
      NULL,
      1.680747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697990,
      NULL,
      3,
      0,
      0.701736,
      0,
      1.888291,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.469969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.749684,
      0.139108,
      1,
      2,
      NULL,
      2,
      3.858669,
      0,
      0,
      1.840068,
      1.679064,
      1,
      NULL,
      0.100762,
      0,
      0.028250,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6,
      '34420',
      '10240',
      '43244',
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


