set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '030',
      '31',
      37.099794,
      0,
      '0210030',
      25.838341,
      4,
      1.430544,
      2,
      '440323',
      0.432171,
      ' 3-17-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.220666,
      0.990360,
      0.131932,
      0,
      3,
      3.294351,
      0,
      0.705705,
      1,
      4,
      NULL,
      3.385138,
      1.778463,
      0,
      8.992829,
      10.335970,
      0,
      7,
      2.780930,
      NULL,
      0,
      0.506018,
      NULL,
      NULL,
      5.841600,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      2,
      3.095627,
      0,
      1.172703,
      NULL,
      3.432760,
      NULL,
      3,
      0.772700,
      1.629175,
      0,
      2,
      1.432987,
      1.568165,
      0,
      1.540863,
      0,
      2,
      3,
      1.700489,
      NULL,
      NULL,
      2,
      4.886761,
      NULL,
      NULL,
      NULL,
      0.624685,
      NULL,
      NULL,
      NULL,
      0.570258,
      3,
      NULL,
      4.161850,
      1.243742,
      NULL,
      NULL,
      0,
      0.604461,
      0.624703,
      NULL,
      1,
      1.067368,
      0,
      0.952900,
      0.223608,
      1.499361,
      0,
      NULL,
      NULL,
      2.677819,
      1,
      1.825589,
      0,
      1,
      0,
      NULL,
      4.046504,
      0,
      0.414966,
      NULL,
      0,
      1.493856,
      2,
      0.054971,
      4.080746,
      4,
      0,
      4,
      1.187735,
      2,
      5,
      NULL,
      4.140773,
      1.067433,
      NULL,
      NULL,
      1.813517,
      NULL,
      0.707268,
      3,
      0.599470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1.866527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.492555,
      3.649302,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.653875,
      1.014279,
      1,
      0,
      4.606038,
      0,
      3.309883,
      0,
      NULL,
      NULL,
      0.455953,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      2.103711,
      NULL,
      0.187141,
      NULL,
      NULL,
      0.909996,
      0.716605,
      1.056287,
      1,
      1,
      1.105458,
      NULL,
      1,
      0,
      1.083211,
      1.244361,
      2.559114,
      3,
      0,
      NULL,
      0.042775,
      NULL,
      0.229753,
      2,
      NULL,
      0,
      0.173269,
      0,
      0,
      NULL,
      1.379221,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0.393229,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.575196,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.798397,
      1,
      0,
      NULL,
      NULL,
      1.814545,
      0.534412,
      2,
      2,
      '41430',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      0.936994,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


