set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '334',
      NULL,
      NULL,
      NULL,
      '0224241',
      0,
      2,
      NULL,
      3,
      '120012',
      NULL,
      ' 3- 4-1980',
      NULL,
      44.651098,
      0,
      NULL,
      1,
      3.749832,
      1.354393,
      NULL,
      1.505755,
      NULL,
      3,
      0.363534,
      1,
      1.946445,
      0,
      0,
      NULL,
      0,
      1,
      3,
      7.369483,
      2,
      0,
      2.707826,
      3,
      NULL,
      0.712121,
      1,
      1,
      0.545917,
      1.124276,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.761804,
      0.155314,
      1,
      1.077412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.883765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.053298,
      1,
      0,
      0.316361,
      NULL,
      0.259623,
      1,
      0,
      1,
      1,
      1.280156,
      1.438636,
      1.032671,
      1,
      0.490339,
      NULL,
      1,
      0,
      NULL,
      1,
      0.696443,
      1.247593,
      0.453499,
      1.715040,
      0,
      1,
      NULL,
      1.850929,
      1.563214,
      NULL,
      2,
      0.476758,
      1.520689,
      3.268961,
      1,
      1,
      0,
      1.443653,
      0,
      7,
      5.921180,
      3,
      NULL,
      2.254935,
      1,
      NULL,
      0.843850,
      1.318677,
      NULL,
      NULL,
      0.582606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083494,
      1.332726,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1.160013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.365908,
      NULL,
      NULL,
      NULL,
      NULL,
      3.289409,
      2,
      NULL,
      0,
      1,
      3.029681,
      1.921697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.868443,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.320284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.199449,
      2.031591,
      NULL,
      0.069838,
      1,
      1.303101,
      2.000871,
      2.415403,
      0,
      0.982516,
      NULL,
      1.583367,
      0,
      0,
      0.662094,
      NULL,
      0,
      1.420311,
      0.098305,
      2.519899,
      0,
      1,
      1,
      1.253629,
      NULL,
      NULL,
      2,
      1,
      1.029193,
      NULL,
      NULL,
      NULL,
      0.601838,
      0,
      0,
      0,
      0,
      1.737607,
      1,
      1,
      1.117354,
      NULL,
      3.615609,
      0.885060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.030157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.678656,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      7.082326,
      '13412',
      '44220',
      '22203',
      1.497534,
      NULL,
      NULL,
      '',
      0.511706,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


