set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '424',
      '43',
      43.175220,
      38.431165,
      '0243224',
      21.304399,
      6,
      0.517563,
      NULL,
      '110121',
      2,
      ' 2-13-2003',
      38,
      39.019623,
      1.544966,
      NULL,
      NULL,
      0.729477,
      NULL,
      1.182393,
      NULL,
      0.858989,
      1,
      1.941454,
      0.652946,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      2,
      0,
      1.874316,
      1.560062,
      1,
      3,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.029007,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.837838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.669153,
      1.560014,
      NULL,
      0.759050,
      0.187998,
      0,
      1,
      NULL,
      0.822076,
      0,
      0.993404,
      0,
      NULL,
      1.874122,
      0.081945,
      0.225379,
      0,
      NULL,
      NULL,
      NULL,
      0.669485,
      0.099288,
      NULL,
      NULL,
      0.077993,
      1,
      1.404868,
      0.131160,
      5.041769,
      1.332965,
      0.028844,
      NULL,
      NULL,
      1,
      2.598731,
      1,
      1,
      0.416388,
      1.204372,
      3.260962,
      1.649186,
      5.378725,
      1,
      4,
      NULL,
      0,
      5.253218,
      1,
      1,
      NULL,
      NULL,
      0.595010,
      1.943596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076145,
      0.312174,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.247830,
      3.995136,
      2.529326,
      1.966634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.185509,
      0.301258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263167,
      NULL,
      NULL,
      0.764938,
      3,
      0.375188,
      1.683838,
      1,
      1,
      0,
      0.017851,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      3.899351,
      1,
      0,
      NULL,
      0,
      1.194607,
      0.886183,
      0.330493,
      1,
      1,
      NULL,
      0,
      0.721234,
      0.189689,
      1.900921,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      3.216575,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401679,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873089,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266819,
      0.293875,
      0.367995,
      NULL,
      0.888381,
      1,
      1.182601,
      2,
      2.522068,
      '02041',
      '02012',
      '42104',
      0,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      2,
      NULL,
      2.220078,
      NULL,
      2,
      2.237034,
      1);
commit;
end;
/


