set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '410',
      '23012303',
      48,
      22,
      '4143032',
      13,
      1,
      0,
      3,
      '141100',
      0,
      ' 5-13-1983',
      40.955433,
      1,
      1,
      NULL,
      NULL,
      2,
      0,
      1.368276,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.616591,
      0,
      0.456458,
      0,
      NULL,
      4,
      1.643949,
      2.229987,
      1,
      0,
      0,
      0,
      0,
      5.884477,
      NULL,
      0.418419,
      1.329366,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.308191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.764134,
      3.688518,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.360542,
      0.785679,
      0.154117,
      1,
      4.373059,
      0,
      0,
      1.382246,
      0,
      0.743402,
      0.675448,
      0,
      0.641765,
      1,
      0.933962,
      0.825053,
      1,
      1,
      1.796627,
      NULL,
      1.035420,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.903816,
      5.798636,
      0.123716,
      1,
      3,
      0.517773,
      NULL,
      NULL,
      1,
      2.760504,
      1,
      3,
      4,
      1.207963,
      3.082043,
      3.227004,
      3,
      2.351357,
      1,
      8,
      NULL,
      0,
      NULL,
      NULL,
      8,
      1.659532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      0.937724,
      0.267864,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.979919,
      NULL,
      5,
      2,
      2.824660,
      0.251375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.318739,
      1,
      4.526584,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.067783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      0.254512,
      0,
      1,
      1.620228,
      0,
      2.946948,
      1.793900,
      0.576906,
      1.375479,
      1,
      0,
      1.469472,
      1,
      1.398763,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.597728,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.644566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.969485,
      0,
      1,
      NULL,
      NULL,
      0.323491,
      NULL,
      1,
      5.377529,
      '33234',
      '30310',
      NULL,
      0.586091,
      NULL,
      '',
      NULL,
      0.764482,
      NULL,
      '',
      '',
      4,
      2,
      NULL,
      NULL,
      2,
      4,
      3.803532,
      NULL,
      NULL);
commit;
end;
/


