set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '004',
      NULL,
      26.852203,
      57,
      '3342234',
      91,
      1,
      2.867746,
      2,
      '040131',
      3.088460,
      NULL,
      NULL,
      27,
      1.734959,
      NULL,
      3,
      1,
      0,
      1,
      1,
      0,
      3,
      0.259271,
      0.748248,
      1,
      3,
      1,
      0.487789,
      3.010404,
      6.207079,
      3,
      0.208017,
      0,
      3.652414,
      NULL,
      3,
      2,
      6,
      1,
      5.710305,
      2,
      2.980505,
      NULL,
      NULL,
      NULL,
      0.977121,
      NULL,
      NULL,
      NULL,
      3.738287,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.033542,
      0.974343,
      4.187022,
      2.551751,
      1,
      0,
      1.686247,
      NULL,
      NULL,
      NULL,
      0.248462,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      4.265734,
      0,
      0,
      NULL,
      1,
      1.574303,
      1.086762,
      1,
      NULL,
      1.406477,
      1.888184,
      1.782026,
      0.448916,
      0.393907,
      1.132410,
      NULL,
      NULL,
      NULL,
      1.234033,
      0.502340,
      0,
      0,
      1,
      1,
      3.873557,
      1,
      NULL,
      0,
      1,
      0,
      3,
      1.245165,
      1,
      9.963179,
      1,
      0,
      NULL,
      5,
      4,
      4,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.718827,
      0,
      1,
      0,
      0.070367,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739721,
      NULL,
      5,
      1.358970,
      0,
      2.545004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.017292,
      3.532109,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.454220,
      NULL,
      0,
      NULL,
      2,
      3.739695,
      NULL,
      NULL,
      NULL,
      1.785446,
      2,
      0.583880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.940645,
      3.057235,
      0,
      3,
      0,
      1,
      2.804172,
      NULL,
      NULL,
      0,
      0.333192,
      2,
      0,
      2,
      1.871803,
      3,
      1.149205,
      NULL,
      0.002478,
      1,
      3,
      1,
      NULL,
      3.596609,
      2.011715,
      3.603009,
      1.218383,
      NULL,
      0,
      1.021984,
      1,
      1,
      0,
      0.080825,
      1.938265,
      1,
      NULL,
      1.555447,
      1.056717,
      1.047225,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.967049,
      0,
      1.795731,
      NULL,
      0,
      1,
      0.925721,
      0,
      3,
      NULL,
      '22404',
      '04401',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.003375,
      3,
      1.726307,
      NULL,
      3,
      0,
      1,
      3,
      3.423996);
commit;
end;
/


