set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '404',
      '21010304',
      NULL,
      NULL,
      NULL,
      40,
      1,
      2,
      3,
      '324300',
      2.015743,
      ' 1-28-2003',
      22.834926,
      29.697160,
      1.543325,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.958633,
      0.283224,
      0.609994,
      1.750436,
      0,
      1.465650,
      NULL,
      1.508758,
      1.815105,
      2.586379,
      0.649289,
      5,
      5,
      0.910976,
      NULL,
      3,
      3.559833,
      4,
      4.039498,
      0,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.264010,
      1.017654,
      1,
      1.069849,
      NULL,
      0,
      3,
      3.438596,
      0.632309,
      3,
      1,
      NULL,
      1,
      2,
      1.741031,
      1,
      1.515156,
      1,
      0.018218,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.696620,
      1.771812,
      NULL,
      NULL,
      0.101066,
      NULL,
      NULL,
      1.150165,
      0.054628,
      0.808515,
      NULL,
      1.374377,
      1,
      1,
      1.255060,
      1,
      0.107069,
      0,
      1,
      1.034777,
      0,
      NULL,
      1.787077,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0.178168,
      1,
      0,
      1.539222,
      NULL,
      0.502686,
      1,
      1.849572,
      1,
      0,
      NULL,
      0.669110,
      4,
      0,
      3,
      4,
      2,
      7.092051,
      NULL,
      3.263244,
      NULL,
      1.036040,
      1,
      1,
      4.517591,
      NULL,
      2,
      1.124611,
      0,
      5.336029,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.376932,
      0.905978,
      1,
      NULL,
      0.118756,
      0.924076,
      NULL,
      1.815471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.363497,
      NULL,
      2,
      0.184918,
      1,
      2.843681,
      0,
      NULL,
      1,
      1.385392,
      NULL,
      2.702034,
      2,
      1.505460,
      NULL,
      NULL,
      NULL,
      2.227739,
      1.428591,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.600958,
      0.147377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      1.663204,
      2.666633,
      0,
      1,
      1,
      0.590413,
      1.846450,
      0.064709,
      0.088125,
      0.662059,
      1.240685,
      1.445294,
      0.159134,
      0,
      0.192361,
      NULL,
      1,
      1.217089,
      NULL,
      0.832833,
      NULL,
      1.266495,
      2.550873,
      2,
      0.967681,
      1,
      1,
      1.003820,
      0.779778,
      NULL,
      NULL,
      0.753400,
      1,
      NULL,
      1.588667,
      NULL,
      0.085343,
      1,
      0.022676,
      NULL,
      1.039691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.614271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.557354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.255515,
      1.669870,
      NULL,
      NULL,
      1.249843,
      1,
      NULL,
      0.066378,
      '11020',
      '01422',
      '01024',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      4,
      0,
      2.128579,
      7.951247,
      0.920197,
      7.986934,
      0.586400,
      0,
      3);
commit;
end;
/


