set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '434',
      '14412012',
      27,
      11.151581,
      '4212213',
      55.511285,
      0,
      0,
      NULL,
      '014342',
      1.573789,
      ' 3-10-1984',
      55.108701,
      34.086253,
      NULL,
      NULL,
      1.492658,
      3.755196,
      0.575074,
      1,
      NULL,
      NULL,
      1.939838,
      1.716325,
      NULL,
      1,
      6.991233,
      0.785394,
      0,
      2.640933,
      0.338771,
      1.742915,
      NULL,
      1.142573,
      NULL,
      0.773717,
      0.153816,
      3,
      5,
      1,
      3.379582,
      2,
      3.344107,
      0,
      NULL,
      NULL,
      0.110952,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542401,
      0.920910,
      0,
      1.171291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      3,
      1.881224,
      NULL,
      0.971466,
      1,
      1.007820,
      1,
      1,
      0.051823,
      0.925492,
      0,
      0.742532,
      NULL,
      0,
      1,
      NULL,
      1,
      0.415328,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      5,
      1,
      1.297424,
      0.622618,
      1,
      1,
      NULL,
      0,
      0.349921,
      1,
      NULL,
      4.154043,
      5.566088,
      3.840263,
      1.751265,
      0.734694,
      2.870672,
      0.064121,
      1,
      2,
      NULL,
      1.551827,
      1,
      NULL,
      0.424421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.192083,
      0,
      2,
      0.163238,
      1.839022,
      1.115356,
      0.312288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.587079,
      2,
      NULL,
      3,
      2.652107,
      1,
      1,
      0,
      4.286445,
      0.532384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.486064,
      3.565837,
      NULL,
      3.938495,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.920367,
      0.829803,
      1.758994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.355918,
      0.018152,
      1.611283,
      1.063729,
      1.003453,
      NULL,
      1,
      0.485876,
      1,
      2,
      1,
      1.577829,
      0.676132,
      1,
      0,
      1.086729,
      1.678374,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.891177,
      2.684046,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.983952,
      0,
      1.534243,
      1.629618,
      1.291037,
      NULL,
      1,
      0.627877,
      0.127429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.939442,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.037991,
      1.819997,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.754969,
      '14314',
      '14100',
      '31214',
      0.722223,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      0.198106,
      0,
      7.253286,
      1,
      5.936541,
      2,
      3.991600,
      5);
commit;
end;
/


