set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '141',
      NULL,
      4,
      63.359320,
      '4420312',
      NULL,
      2,
      2.201878,
      NULL,
      '130140',
      1.961673,
      NULL,
      NULL,
      46.243514,
      1.364086,
      NULL,
      0.406743,
      2,
      0,
      1.203905,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4.281733,
      0.036186,
      0,
      4,
      NULL,
      2,
      6.015921,
      1,
      NULL,
      1.931757,
      1,
      0,
      0.916150,
      1,
      NULL,
      3.953790,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.533637,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.426070,
      0,
      0.248173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356842,
      0.248517,
      NULL,
      NULL,
      NULL,
      NULL,
      0.799194,
      NULL,
      1,
      0,
      0,
      1,
      0.897866,
      NULL,
      NULL,
      1,
      1,
      0.700561,
      1.204694,
      NULL,
      1.154227,
      0.334079,
      1.373625,
      1,
      NULL,
      1.178334,
      NULL,
      1,
      NULL,
      1.054481,
      0.928597,
      4,
      0,
      1,
      4.753706,
      0.518722,
      3.883898,
      3.438415,
      NULL,
      0.022249,
      3.412310,
      5,
      1,
      1.337986,
      4,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1.242179,
      7.607867,
      0.565632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.852941,
      NULL,
      2,
      0.237767,
      NULL,
      0.415230,
      0.694335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733380,
      NULL,
      6,
      2.942788,
      0.453760,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.035363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.126079,
      0,
      0.344037,
      0,
      4.610084,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.741423,
      1.747087,
      NULL,
      0.358647,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0.986271,
      1.046120,
      1,
      1.995555,
      1,
      0.409613,
      0.562833,
      1.021658,
      NULL,
      1,
      1,
      1.376934,
      3.395293,
      NULL,
      NULL,
      1,
      0,
      0.989874,
      1.534820,
      0.253356,
      0,
      1.499669,
      1,
      1.179607,
      1,
      1.664463,
      1.513575,
      0,
      NULL,
      NULL,
      0,
      1.334238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.297312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0.082796,
      0,
      1,
      5.472325,
      '41002',
      '04032',
      '11030',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      4.656701,
      7,
      1.136391,
      7,
      1,
      7,
      1.791115,
      NULL,
      5.453084);
commit;
end;
/


