set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '301',
      '11022444',
      NULL,
      7,
      '4211432',
      40,
      0,
      NULL,
      2,
      NULL,
      0.336949,
      ' 2- 7-1992',
      19.937984,
      20,
      0.523895,
      NULL,
      NULL,
      2.239488,
      1.740244,
      0.607656,
      0,
      3.940448,
      3.545536,
      0.361344,
      1,
      0,
      1.079579,
      1.912112,
      0,
      4,
      0,
      0.179421,
      NULL,
      1.704876,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      3.996705,
      5.301301,
      1,
      NULL,
      NULL,
      NULL,
      1.395928,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1.034057,
      1.192425,
      NULL,
      0,
      0.646663,
      NULL,
      NULL,
      0.332805,
      1.016804,
      2.231847,
      NULL,
      NULL,
      2.474327,
      1.902879,
      1.947412,
      0.939834,
      0,
      1.540011,
      4,
      0,
      1,
      1.003895,
      1.673834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746407,
      0.706085,
      1,
      NULL,
      3,
      1,
      1.534520,
      0,
      NULL,
      0.603843,
      0.946375,
      1,
      NULL,
      0,
      NULL,
      0,
      0.352182,
      1,
      NULL,
      NULL,
      0.044155,
      NULL,
      0.700648,
      NULL,
      NULL,
      0.021208,
      1,
      0,
      5.755679,
      NULL,
      0,
      4.512955,
      0.304493,
      1.584717,
      0.168009,
      0,
      3.122445,
      6,
      2,
      2.821231,
      7.542432,
      NULL,
      NULL,
      1.743916,
      NULL,
      0,
      4,
      5,
      2.537938,
      1,
      1.171406,
      9.560558,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1.327342,
      1,
      1.355286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.209081,
      NULL,
      8,
      0.497109,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.616577,
      0.406809,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      1,
      2,
      NULL,
      2,
      0.548391,
      NULL,
      NULL,
      NULL,
      1.369342,
      1.198780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.598763,
      1,
      3.094537,
      NULL,
      1.857777,
      1,
      1.762161,
      1,
      1.925346,
      NULL,
      0.353502,
      0,
      0.342460,
      1.753159,
      0,
      1.781372,
      0,
      1.780251,
      1.840451,
      1.818478,
      1,
      NULL,
      0.370850,
      1,
      2,
      0.124702,
      3.088086,
      1,
      NULL,
      NULL,
      1.226154,
      0,
      0.610855,
      1,
      0.422248,
      0,
      1,
      1.416963,
      1,
      NULL,
      1,
      NULL,
      3.620392,
      0.657444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.407178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.077198,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816043,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.753722,
      3,
      4.900333,
      NULL,
      0,
      0.547557,
      1,
      6.072453,
      '24044',
      '43004',
      '43110',
      0,
      '',
      '',
      '',
      0.278638,
      '',
      '',
      NULL,
      4.197584,
      4.752811,
      3,
      NULL,
      0.641982,
      1,
      2,
      0,
      2.993485);
commit;
end;
/


