set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0132',
      NULL,
      17.543691,
      43.230303,
      '3314103',
      96,
      4,
      0,
      2,
      '313140',
      4,
      ' 7-20-2003',
      NULL,
      9.212797,
      0,
      NULL,
      1.115909,
      2,
      0,
      0,
      0,
      1.354855,
      NULL,
      0.816336,
      NULL,
      1.046323,
      5,
      0.650174,
      1,
      4.004783,
      1.345060,
      NULL,
      7.064989,
      1.932267,
      1.044542,
      2.984381,
      3,
      1.703664,
      7,
      0,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.708058,
      0.738427,
      3,
      NULL,
      1.603020,
      0.789987,
      0,
      0.137675,
      0.947221,
      2.751011,
      2.489289,
      NULL,
      NULL,
      3,
      1.405243,
      0,
      2.247956,
      1.146834,
      1.737186,
      NULL,
      0,
      0.986773,
      7.861610,
      1,
      0,
      1.625942,
      1.793134,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.738603,
      NULL,
      0.197643,
      0.193031,
      1.881226,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0.213011,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.474618,
      0,
      1.177662,
      NULL,
      1,
      1.885577,
      5,
      0,
      NULL,
      NULL,
      0.832549,
      1,
      NULL,
      0,
      3.544958,
      3,
      0.814981,
      3,
      4.796964,
      7,
      2.349981,
      2.806331,
      4,
      1.010961,
      1.451139,
      1.654169,
      2,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.214342,
      0.500849,
      NULL,
      2,
      1,
      NULL,
      2.725675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.109761,
      NULL,
      4.635003,
      2.457451,
      3,
      5.105047,
      2,
      1,
      1.363131,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.511639,
      0,
      5.899766,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.553370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.135589,
      1.229356,
      3.085558,
      0.833710,
      2,
      1.193358,
      1,
      3.044823,
      0,
      NULL,
      3.280972,
      0,
      1.865079,
      0.518514,
      1,
      1,
      NULL,
      NULL,
      0.116272,
      0.142990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '30324',
      '21132',
      '32102',
      0,
      '',
      '',
      '',
      1.742965,
      NULL,
      '',
      '',
      NULL,
      5,
      NULL,
      NULL,
      3.898827,
      6.286195,
      2,
      0,
      2);
commit;
end;
/


