set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0230',
      '14240243',
      13.814103,
      NULL,
      '2441201',
      124.851100,
      0,
      0,
      1,
      '424021',
      5.743541,
      NULL,
      NULL,
      64.807363,
      1.764451,
      NULL,
      NULL,
      1.159196,
      0.938453,
      0,
      1.576013,
      3,
      0,
      0,
      1,
      0.793432,
      3.654832,
      1,
      1.375547,
      4,
      1.446304,
      NULL,
      6.981211,
      1,
      5.960089,
      2.747938,
      3.225091,
      0.852432,
      1.123281,
      NULL,
      4,
      3.931464,
      3.950272,
      1.393625,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.098413,
      0.672733,
      2,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.588456,
      0,
      4.906101,
      1.022596,
      0.763702,
      1,
      0.011844,
      NULL,
      1,
      NULL,
      0.414298,
      0.860263,
      1,
      0.861065,
      0.707856,
      1.272460,
      0.603633,
      0.320354,
      0.687390,
      NULL,
      1.769721,
      0.463849,
      NULL,
      NULL,
      0,
      1.405061,
      1.337502,
      1.476127,
      5,
      0.342185,
      2,
      1.698889,
      NULL,
      1,
      2.627785,
      0.316353,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      2,
      4.361389,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      7.227904,
      1.353315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0.313996,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.439376,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.470711,
      0.600620,
      2,
      1.362765,
      0.698235,
      1.383146,
      1,
      NULL,
      5.350122,
      5.587455,
      NULL,
      2,
      1.262477,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515839,
      1.253404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.143588,
      0,
      0,
      1,
      3,
      3.774126,
      1,
      0.996787,
      1,
      0.841249,
      NULL,
      1.555545,
      NULL,
      1.693940,
      0.575768,
      NULL,
      0.465645,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.068726,
      '21013',
      '41330',
      '22220',
      0.453520,
      '',
      NULL,
      '',
      0.031081,
      NULL,
      '',
      NULL,
      NULL,
      5,
      2,
      0.234874,
      3,
      NULL,
      NULL,
      2,
      3);
commit;
end;
/


