set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2324',
      '33224410',
      6,
      82,
      NULL,
      33.943283,
      1,
      0,
      NULL,
      '420034',
      4.515017,
      ' 8-14-1996',
      36.362235,
      31,
      NULL,
      NULL,
      2,
      1,
      1.528107,
      NULL,
      1.087919,
      3.254748,
      1.197113,
      0,
      0,
      1.324734,
      3,
      1.414923,
      1,
      2.383263,
      NULL,
      2,
      2,
      5.855793,
      5,
      3.962100,
      3.352598,
      0,
      6,
      NULL,
      0.019461,
      3,
      1,
      0,
      NULL,
      NULL,
      0.396479,
      NULL,
      NULL,
      3.874571,
      0,
      1.792233,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.256187,
      0,
      1.425535,
      NULL,
      0,
      1,
      0.340285,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.287930,
      3,
      NULL,
      0.417102,
      1,
      0.955522,
      0.492821,
      0,
      0.682337,
      0.783938,
      1,
      0,
      1,
      NULL,
      0.823472,
      0.444279,
      1.738560,
      0,
      NULL,
      NULL,
      NULL,
      0.997859,
      0,
      0.146373,
      NULL,
      NULL,
      1.071764,
      NULL,
      1.695095,
      2,
      6.686637,
      2,
      1,
      0.236938,
      1.814184,
      3.425234,
      7,
      NULL,
      4,
      NULL,
      5,
      8.221412,
      3.540437,
      NULL,
      1,
      NULL,
      2.437229,
      0.508733,
      1,
      1.910173,
      1.338944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.877118,
      NULL,
      2,
      1,
      1,
      0,
      0.121621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.637843,
      1,
      0,
      1,
      2.215802,
      3,
      NULL,
      0.834070,
      1,
      NULL,
      1.520677,
      0,
      1.176117,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.011219,
      1,
      1,
      2,
      0,
      1.502062,
      0,
      0,
      1,
      0.584740,
      0.564278,
      1.113703,
      NULL,
      0.462355,
      1,
      0.569860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.299463,
      0.074407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.172011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.659745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.201458,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640272,
      1,
      NULL,
      NULL,
      0.820148,
      1.272795,
      1.762676,
      2,
      NULL,
      '40310',
      '32112',
      '34401',
      0,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      6.617670,
      NULL,
      4,
      0,
      7.041556,
      NULL,
      2,
      2.862843);
commit;
end;
/


