set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33',
      5.395429,
      16.335455,
      '2444112',
      49,
      3,
      NULL,
      0,
      NULL,
      NULL,
      ' 1-12-1980',
      42.226029,
      8,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1.822546,
      1.315055,
      0.315858,
      1,
      NULL,
      NULL,
      1.512298,
      1,
      1,
      0,
      1,
      1.181729,
      0,
      1,
      0.772714,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.934844,
      0.648239,
      NULL,
      2,
      0,
      0.644876,
      2.614205,
      1.999235,
      1.084919,
      2,
      NULL,
      NULL,
      0,
      1.785944,
      0,
      1,
      0.152653,
      1.419481,
      0,
      0,
      1,
      1.445260,
      NULL,
      0,
      NULL,
      1.554235,
      1.305611,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1.036842,
      NULL,
      0.216162,
      0,
      0.948503,
      1.479406,
      0,
      1,
      0,
      0.325043,
      NULL,
      0.923017,
      1,
      NULL,
      0,
      NULL,
      0.618015,
      2,
      0.712558,
      NULL,
      NULL,
      1,
      0,
      1.965132,
      1.244295,
      3.557293,
      1,
      2.678910,
      4.676577,
      NULL,
      3.389503,
      NULL,
      3.895012,
      5,
      0.763506,
      NULL,
      5,
      2,
      0.507528,
      1.328213,
      2.214695,
      3,
      11.634470,
      0.143735,
      1.429526,
      NULL,
      NULL,
      5.123679,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0.034043,
      1,
      1.933096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.789028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.671813,
      0,
      0.156624,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.302001,
      1,
      1,
      0.533020,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.447307,
      0,
      NULL,
      1.518824,
      1.607217,
      1,
      0,
      0.259516,
      0.279862,
      NULL,
      3,
      0,
      1.479155,
      0.680292,
      NULL,
      1.367862,
      NULL,
      1.553855,
      1,
      1.637899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '40444',
      '0340',
      '',
      3.994292,
      '343',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


