set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '131',
      NULL,
      5,
      13,
      '1332333',
      43.474112,
      5,
      3.703559,
      NULL,
      '441033',
      0,
      '10- 0-1974',
      20,
      38.888936,
      1.669727,
      NULL,
      0.080115,
      0,
      0,
      1,
      0.543622,
      0.719208,
      1.479857,
      0.453234,
      2,
      0.737298,
      1,
      1,
      0,
      0,
      NULL,
      0,
      2.016874,
      0.049463,
      3.017882,
      0.750054,
      1.124356,
      1,
      2.644018,
      0,
      NULL,
      0,
      NULL,
      1.053031,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.254136,
      NULL,
      2.968684,
      3.860420,
      NULL,
      0,
      1.654193,
      1,
      NULL,
      3.171568,
      2,
      1.572297,
      2.829718,
      2,
      0,
      3,
      1.003984,
      1.771765,
      1,
      0,
      0,
      1,
      5,
      1,
      1,
      NULL,
      1.075950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.707559,
      1.158715,
      0.481543,
      0,
      1.282017,
      0.002015,
      0,
      0.978773,
      1.532576,
      0.621105,
      NULL,
      1,
      NULL,
      0.960937,
      0.989060,
      1.667100,
      1.968997,
      NULL,
      0,
      5.244465,
      1,
      NULL,
      0,
      0,
      NULL,
      0.479289,
      4.487460,
      1.005912,
      4.287263,
      1,
      1.549163,
      2,
      0.377088,
      1.267465,
      3.511144,
      NULL,
      3,
      4,
      NULL,
      8.359962,
      3,
      3.346637,
      7.786271,
      4,
      1.524722,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.424781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.554358,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.307924,
      3,
      0.816542,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.538901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202312,
      1.087837,
      NULL,
      1,
      0,
      0,
      NULL,
      3.432913,
      NULL,
      1,
      2,
      1,
      1,
      0.576025,
      0,
      0.211921,
      1,
      0.799729,
      0.033585,
      0.722107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '14202',
      NULL,
      '',
      NULL,
      '102',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


