set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00',
      39,
      22,
      '2414420',
      NULL,
      5,
      1.393629,
      3,
      '242300',
      1,
      ' 4- 0-1999',
      5.949580,
      NULL,
      1.068876,
      NULL,
      1.982776,
      1.382291,
      3.391126,
      NULL,
      1,
      0.431896,
      0,
      0.221814,
      2.330150,
      0.572183,
      1.087487,
      0.201778,
      NULL,
      0.093553,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0.419066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.596262,
      0,
      1,
      2.467946,
      0,
      NULL,
      NULL,
      3.405806,
      0,
      1.112614,
      1.381915,
      3.093616,
      0.520978,
      3.353019,
      1.403686,
      3.777564,
      0,
      0.661667,
      NULL,
      0.420605,
      1.118096,
      0.345989,
      2.801970,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.743036,
      1,
      NULL,
      1,
      NULL,
      0,
      1.814912,
      1.258547,
      1,
      0.845327,
      NULL,
      NULL,
      1,
      1.643472,
      1,
      1,
      NULL,
      NULL,
      1.867848,
      2,
      0.534960,
      0.466386,
      1.065822,
      NULL,
      1.833016,
      0,
      3,
      NULL,
      1,
      1,
      1,
      0,
      5,
      3.131467,
      5,
      0,
      NULL,
      NULL,
      NULL,
      8.155317,
      7,
      7,
      5.867208,
      2,
      10.389797,
      1,
      0.173145,
      NULL,
      NULL,
      4.055561,
      1.900109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.330610,
      1,
      1,
      0,
      1.022436,
      1.066107,
      0,
      0.128364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.644382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.721415,
      0,
      NULL,
      NULL,
      NULL,
      0.275571,
      1.089396,
      3,
      NULL,
      0.884051,
      0,
      0.785969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347722,
      NULL,
      NULL,
      1.146254,
      3,
      0.091666,
      NULL,
      1.642304,
      NULL,
      3,
      0,
      1,
      1.414185,
      NULL,
      1.615188,
      1,
      1,
      NULL,
      1.911006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '33040',
      '1331',
      '',
      3,
      '102',
      '',
      '',
      0.587435,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


