set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '311',
      '24231012',
      48,
      22.686374,
      NULL,
      130.675831,
      1,
      NULL,
      2,
      '203044',
      2,
      '10- 1-1989',
      38,
      46,
      0,
      NULL,
      1.286492,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      3,
      0.346454,
      NULL,
      1,
      1,
      1,
      0,
      1.402610,
      2.912717,
      0,
      1,
      1.500670,
      NULL,
      1.745494,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940595,
      1.730796,
      1.019203,
      0.930520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484888,
      1.976538,
      1.691104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.726677,
      1,
      0.268940,
      1.252522,
      0,
      0,
      NULL,
      0.786049,
      1.334639,
      1,
      1.496870,
      0.360229,
      0,
      1,
      1.267132,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.541439,
      0.223149,
      1.662338,
      3.308429,
      2.268814,
      5.880941,
      3.149347,
      NULL,
      2,
      NULL,
      1.363096,
      0,
      3.571186,
      0.631469,
      2,
      1.484642,
      NULL,
      NULL,
      NULL,
      1.332286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856662,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.713969,
      1.991872,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142195,
      0.227806,
      6,
      4,
      1,
      2,
      1.889107,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1.151715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666857,
      NULL,
      0.278714,
      0,
      2,
      1,
      NULL,
      1.120385,
      1.068104,
      0,
      2.980811,
      0.484794,
      1,
      0,
      0.649475,
      1.242862,
      1,
      1.136308,
      1,
      1.450406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      '0314',
      '',
      1.321376,
      '103',
      '',
      '',
      3,
      '0434',
      '',
      '',
      1.036812,
      3.079017,
      NULL,
      1.510471,
      3,
      2.057288,
      NULL,
      2.587271,
      3.964853);
commit;
end;
/


