set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '122',
      '01132222',
      5,
      28.034215,
      '3232312',
      29,
      3,
      1,
      NULL,
      '330221',
      4,
      ' 9- 4-1975',
      23.351941,
      46.097080,
      0,
      NULL,
      0,
      NULL,
      2.578116,
      0,
      NULL,
      0,
      0,
      0.452462,
      1,
      0.988529,
      0.315724,
      NULL,
      NULL,
      0,
      1,
      1.257270,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.276873,
      0.064435,
      NULL,
      2.260724,
      NULL,
      NULL,
      NULL,
      NULL,
      1.589387,
      0,
      NULL,
      0,
      NULL,
      1.551762,
      0.513871,
      1,
      1.455252,
      1,
      NULL,
      1.996513,
      1,
      NULL,
      1.502820,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.349113,
      0,
      NULL,
      0.984734,
      1.744927,
      0,
      1.657313,
      0,
      0,
      1.674394,
      0,
      1.592463,
      0.828972,
      0.500041,
      1.986150,
      1.720588,
      1,
      NULL,
      1.856997,
      NULL,
      1,
      2.583493,
      1,
      0,
      0.162113,
      1,
      1.358741,
      2.875219,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.680862,
      2,
      0,
      3,
      8.135156,
      0.192484,
      7,
      2.906179,
      4.651134,
      0.409406,
      1,
      0,
      2.254221,
      8,
      1,
      3.986782,
      NULL,
      0.238344,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1.604259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.307736,
      NULL,
      4,
      NULL,
      0,
      0.780948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.758463,
      0,
      0.182461,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640627,
      2.366068,
      5,
      1,
      1,
      0.637795,
      NULL,
      NULL,
      NULL,
      NULL,
      4.051762,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.994356,
      1.396229,
      3.000711,
      0.982629,
      1.812863,
      0,
      0.536797,
      0.451251,
      0,
      0.374500,
      0.693021,
      NULL,
      0,
      NULL,
      0,
      0.904422,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.003159,
      '1130',
      NULL,
      '',
      NULL,
      '101',
      '',
      '',
      2.277655,
      NULL,
      '',
      '',
      NULL,
      4.118469,
      NULL,
      2.367461,
      NULL,
      5,
      2.482652,
      1,
      1);
commit;
end;
/


