set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33414321',
      64.448455,
      32,
      '1102240',
      10,
      1,
      1.852428,
      0,
      '303123',
      NULL,
      NULL,
      8.659113,
      28,
      NULL,
      NULL,
      1.338715,
      1,
      0.404084,
      0.722054,
      0,
      1.159109,
      1.061027,
      1.762681,
      3,
      1.055069,
      1,
      0,
      NULL,
      0,
      0.116937,
      0,
      5.895458,
      NULL,
      0.820248,
      NULL,
      1.390054,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1.971199,
      0.538502,
      1,
      NULL,
      1.752886,
      3,
      1,
      NULL,
      3,
      3,
      0,
      2.368585,
      0.058523,
      NULL,
      0.230091,
      0,
      0.782084,
      NULL,
      7,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.187092,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.440942,
      0,
      1,
      0,
      1.061541,
      1.412120,
      1,
      0.320665,
      1.832718,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1.124624,
      0,
      NULL,
      1,
      0,
      5.230906,
      1.036441,
      0.566386,
      NULL,
      5,
      2.350842,
      2,
      0.725466,
      3,
      0.706902,
      5.983355,
      NULL,
      2,
      6,
      0,
      1.150258,
      3,
      7,
      1,
      NULL,
      5.656525,
      2,
      NULL,
      0,
      1.091047,
      3.138800,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.741868,
      0.819329,
      1.189039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315596,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.006896,
      0,
      0.520601,
      NULL,
      0,
      2,
      1,
      0.091946,
      NULL,
      NULL,
      NULL,
      NULL,
      1.587271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.057977,
      3.098184,
      0.694311,
      1,
      NULL,
      1.795523,
      0,
      0,
      1.621488,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0.801350,
      NULL,
      1.662917,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '1332',
      NULL,
      '',
      2,
      NULL,
      '',
      '',
      NULL,
      '3004',
      NULL,
      '',
      1,
      NULL,
      2,
      NULL,
      5.495309,
      3,
      0,
      1,
      0.855795);
commit;
end;
/


