set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '433',
      '34131410',
      46.362106,
      NULL,
      '4004013',
      86,
      NULL,
      2.072787,
      NULL,
      NULL,
      5.283211,
      ' 7-15-1997',
      18,
      32,
      1,
      NULL,
      0.724086,
      1.351075,
      1,
      1.683624,
      0.699069,
      NULL,
      0,
      NULL,
      0,
      0.392857,
      0,
      0,
      1.078441,
      1.748780,
      0.559478,
      0.110614,
      0.293216,
      2,
      1,
      1.651968,
      NULL,
      0.956607,
      1.822551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0,
      2.926124,
      0.554171,
      1,
      2,
      1,
      0,
      NULL,
      3,
      0.113702,
      0,
      3,
      3.291814,
      NULL,
      1,
      NULL,
      NULL,
      3.841336,
      1.430875,
      0,
      7.703891,
      1,
      2,
      0.933982,
      0.613981,
      NULL,
      NULL,
      0.155374,
      NULL,
      NULL,
      NULL,
      0,
      1.150658,
      0,
      1.199935,
      1,
      0,
      0.244324,
      0.085552,
      1.081257,
      0.939307,
      1.622268,
      0,
      0.354829,
      1,
      1,
      1.903046,
      NULL,
      1,
      NULL,
      0,
      3,
      1.764586,
      0.824630,
      1,
      1.488516,
      1,
      0.751843,
      3.324999,
      0,
      NULL,
      0,
      1,
      1.815673,
      NULL,
      NULL,
      4,
      4,
      3,
      6,
      5,
      2,
      5.895096,
      NULL,
      6,
      0,
      7,
      0.481236,
      3,
      1.979490,
      1,
      NULL,
      0.410572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.542254,
      0,
      0,
      0,
      NULL,
      1.330247,
      1.552523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.935700,
      NULL,
      3.881696,
      1.024024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.028759,
      0.464183,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1.810510,
      1.231392,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.066846,
      2,
      0,
      1,
      2.991898,
      1,
      NULL,
      3.726132,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.967335,
      0.318268,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.613902,
      '0324',
      '1241',
      '',
      0,
      '332',
      '',
      '',
      3.434515,
      '0411',
      '',
      '',
      NULL,
      2.521125,
      NULL,
      NULL,
      0,
      0,
      0.153128,
      0.527233,
      1.573708);
commit;
end;
/


