set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '330',
      '33340414',
      NULL,
      16,
      '4013142',
      198.257410,
      4,
      3,
      3,
      '014344',
      2.071410,
      NULL,
      56,
      48.099763,
      NULL,
      NULL,
      0.436750,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      5.346194,
      0,
      1,
      0,
      1.933687,
      1.858334,
      NULL,
      1,
      NULL,
      1.599058,
      1.330778,
      0.666926,
      NULL,
      0,
      NULL,
      1.120630,
      NULL,
      0.140302,
      NULL,
      NULL,
      1.149796,
      NULL,
      NULL,
      9,
      NULL,
      1.272927,
      NULL,
      0,
      0.604712,
      1.403580,
      1,
      1.811664,
      3,
      NULL,
      1.791759,
      2,
      0,
      1.329714,
      3,
      1,
      1.162433,
      1,
      1,
      0,
      NULL,
      9.532152,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.995385,
      NULL,
      NULL,
      1,
      1.838384,
      0.580468,
      1,
      1,
      1.921948,
      1,
      0.691592,
      0.058252,
      0.496224,
      0,
      1,
      0.969005,
      1.238534,
      1,
      0.604761,
      NULL,
      NULL,
      0,
      NULL,
      1.386487,
      2,
      0.109573,
      1,
      1.580136,
      1.095214,
      1.675997,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0.737944,
      0.151379,
      NULL,
      5,
      1,
      5,
      5.124975,
      NULL,
      0,
      5.565460,
      4.124964,
      NULL,
      3.794325,
      1.564292,
      0.810138,
      0,
      1.436395,
      1.569283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.890281,
      0,
      1,
      0,
      0,
      NULL,
      1.333094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.660505,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.855971,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      3,
      3.954387,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.011559,
      NULL,
      2.859456,
      1.006655,
      0.439920,
      0,
      0.792897,
      1.601135,
      NULL,
      2,
      NULL,
      0.305658,
      0,
      NULL,
      0.708327,
      NULL,
      NULL,
      0.072249,
      1,
      1.903444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.774505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '1311',
      '0144',
      '',
      1.431511,
      '342',
      '',
      '',
      2,
      '4413',
      NULL,
      '',
      3,
      2,
      3.633033,
      0,
      3,
      0,
      1.058913,
      1.157591,
      1);
commit;
end;
/


