set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '432',
      NULL,
      54.087929,
      78.263399,
      '4240101',
      202.492300,
      0,
      0,
      NULL,
      '320202',
      6.170412,
      ' 6-29-1984',
      15,
      58,
      0,
      NULL,
      0,
      1,
      0.968920,
      NULL,
      0.746534,
      1.049244,
      1,
      0.645363,
      1,
      0,
      3.004618,
      1.787030,
      0,
      0,
      0,
      NULL,
      1,
      1.690377,
      0,
      NULL,
      NULL,
      1,
      4.553855,
      1,
      2,
      NULL,
      0.879075,
      0,
      NULL,
      NULL,
      1.294996,
      NULL,
      NULL,
      4.298715,
      0,
      3.369886,
      1.763083,
      0,
      0,
      3.919701,
      0,
      1,
      2,
      NULL,
      NULL,
      2,
      0,
      1.165865,
      0.823271,
      0.015623,
      0,
      0.513136,
      NULL,
      NULL,
      0.880312,
      5.110933,
      0,
      NULL,
      1,
      1.358653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.647594,
      5.171235,
      NULL,
      1,
      1.506785,
      0.544291,
      0,
      0.371583,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      1.791984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.138779,
      0.355696,
      0,
      1,
      2,
      4,
      5,
      NULL,
      NULL,
      5.168114,
      1.211377,
      1,
      0,
      8.706351,
      NULL,
      6,
      7.387892,
      7,
      5.862371,
      3.482800,
      NULL,
      1,
      2,
      NULL,
      1.690307,
      0,
      0,
      0.106711,
      1.874747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.116318,
      1,
      2,
      NULL,
      1.967334,
      NULL,
      1,
      1.696579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.796910,
      NULL,
      3,
      5,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      3,
      0.608788,
      0,
      1,
      1.166250,
      3.217251,
      NULL,
      1,
      0.174428,
      1.657732,
      1.293603,
      0.763852,
      1,
      1.003713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      '',
      3.422877,
      '141',
      '',
      '',
      3,
      NULL,
      '',
      '',
      2,
      2.000233,
      0,
      5.646006,
      5.393026,
      0.607590,
      0.680735,
      3.900441,
      NULL);
commit;
end;
/


