set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1031',
      '34013231',
      7.832697,
      76.473176,
      '0013100',
      65.626828,
      2,
      3.569471,
      NULL,
      NULL,
      1,
      ' 9- 8-1975',
      NULL,
      12,
      0.694767,
      NULL,
      0.427951,
      0.139139,
      2,
      1,
      1,
      0.152719,
      0.815553,
      NULL,
      0.226112,
      1.799037,
      1.446542,
      0,
      0,
      1,
      NULL,
      0.037776,
      3.060904,
      0.492970,
      0.403886,
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.031149,
      2,
      NULL,
      0.126958,
      NULL,
      1.063710,
      1.164280,
      2.721330,
      NULL,
      0.838208,
      1,
      3,
      NULL,
      3,
      1,
      0.446304,
      1.721072,
      NULL,
      NULL,
      1,
      5,
      0,
      0,
      0.167567,
      NULL,
      NULL,
      NULL,
      0.958251,
      NULL,
      NULL,
      5.282351,
      5,
      NULL,
      1.028541,
      3.521552,
      0.668819,
      0,
      NULL,
      NULL,
      0,
      0.996572,
      1.126361,
      0,
      NULL,
      1.447292,
      1,
      NULL,
      0.396535,
      0.579370,
      NULL,
      0,
      4.237027,
      0,
      1.045112,
      0.612841,
      0.078089,
      5.572305,
      2.723035,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.784111,
      1.758086,
      NULL,
      4,
      0.620015,
      7.045379,
      3,
      0.634514,
      3.372156,
      4.846061,
      4.677419,
      10,
      NULL,
      3.279165,
      1,
      0,
      NULL,
      1.382740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0.563395,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      2.046033,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.779155,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.124477,
      0.841981,
      1.368249,
      0,
      1.125468,
      1.513013,
      1,
      2.607479,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0.643193,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.411952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.842085,
      '1403',
      NULL,
      '',
      0,
      '124',
      NULL,
      '',
      0,
      '2000',
      '',
      '',
      NULL,
      5,
      3.082834,
      3.990783,
      0,
      1.768368,
      3,
      3.588633,
      2);
commit;
end;
/


