set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3042',
      '11231030',
      23.997980,
      55,
      '3223231',
      57,
      2,
      NULL,
      0,
      '301101',
      NULL,
      ' 8-27-1998',
      5,
      56.333004,
      0,
      NULL,
      0.899067,
      0,
      0,
      1.613130,
      1.446317,
      0,
      0.674812,
      1.409951,
      0.362819,
      NULL,
      1.788967,
      NULL,
      0.868179,
      1.533347,
      1.402799,
      1,
      4.482836,
      0.818831,
      1.801977,
      NULL,
      1.086866,
      NULL,
      5.225348,
      NULL,
      3,
      1.464431,
      0.611704,
      NULL,
      NULL,
      NULL,
      1.207708,
      NULL,
      NULL,
      7.127205,
      NULL,
      NULL,
      3.484568,
      0,
      0.228105,
      3,
      0.442700,
      1.061551,
      1,
      3.040655,
      1,
      1.383845,
      NULL,
      0,
      2,
      0.344203,
      1.448013,
      1,
      NULL,
      0,
      0,
      1.046810,
      NULL,
      NULL,
      1.026371,
      0.470676,
      NULL,
      NULL,
      0.411794,
      NULL,
      NULL,
      0,
      1,
      0.005310,
      1,
      3,
      0,
      0.790549,
      NULL,
      NULL,
      1.985383,
      1.495572,
      0.419839,
      1,
      1,
      1.247175,
      1,
      0,
      1,
      1.360916,
      NULL,
      NULL,
      1,
      1,
      0,
      1.425887,
      0,
      4,
      2.181773,
      NULL,
      NULL,
      NULL,
      NULL,
      4.267392,
      NULL,
      4.461336,
      0.033609,
      6,
      NULL,
      1,
      NULL,
      6,
      1,
      6.340781,
      1,
      1.069623,
      1,
      1,
      7,
      0,
      1,
      0,
      1,
      0.133121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433672,
      0.108466,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      2.238513,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.522761,
      0,
      0.014184,
      NULL,
      2.534936,
      1,
      NULL,
      0,
      4,
      4,
      4,
      0,
      NULL,
      1.137294,
      NULL,
      NULL,
      1,
      2,
      1.216365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673342,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.468303,
      1.477823,
      0,
      0.816858,
      0.565069,
      0,
      1,
      0.806843,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      '0300',
      '2404',
      NULL,
      NULL,
      '123',
      '',
      '',
      1,
      '0432',
      '',
      '',
      NULL,
      0,
      2,
      2,
      2.013810,
      0,
      NULL,
      2,
      0.489003);
commit;
end;
/


