set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4400',
      NULL,
      68.070398,
      67.455395,
      '1103043',
      19,
      0,
      2.155976,
      1,
      '003330',
      4.459877,
      NULL,
      NULL,
      43,
      NULL,
      NULL,
      1,
      0.535151,
      0,
      1.434160,
      1.682453,
      1,
      0.313205,
      NULL,
      3.663914,
      0.349042,
      4,
      0.901678,
      0,
      1.659807,
      NULL,
      1.420435,
      5,
      1,
      NULL,
      1.744171,
      0.104779,
      NULL,
      3,
      0,
      1.355704,
      0,
      1.303200,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073637,
      0,
      1,
      3.192832,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      1.798842,
      3,
      2.018630,
      1.441606,
      3.122411,
      1.989710,
      1,
      0,
      1,
      1.426895,
      1.948262,
      0.917146,
      1,
      2,
      1.571821,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4,
      0.642673,
      0,
      0,
      NULL,
      0.085815,
      NULL,
      1,
      0.933799,
      0.607255,
      1.724051,
      1.677298,
      1,
      1,
      0.460801,
      1,
      1.454860,
      0.852207,
      NULL,
      0.139700,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.320077,
      0,
      1.688743,
      6.350675,
      6.227350,
      9.212560,
      5,
      4.996964,
      3.303425,
      3,
      3,
      6,
      0.737215,
      9,
      7,
      NULL,
      1,
      NULL,
      NULL,
      1.083741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576093,
      0.033878,
      1,
      1,
      1.029717,
      1.051814,
      NULL,
      0.254497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.301417,
      NULL,
      NULL,
      3,
      3.943836,
      1.033575,
      3,
      2,
      1.148337,
      0,
      3,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.902420,
      NULL,
      NULL,
      6,
      5.224558,
      2,
      5.487354,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.789739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371757,
      1.034237,
      3.691318,
      1.535126,
      1,
      2.074107,
      NULL,
      2.847388,
      NULL,
      3.635142,
      0.709458,
      0,
      NULL,
      0,
      1.274645,
      0.118061,
      NULL,
      NULL,
      1.221652,
      0.076319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '4132',
      NULL,
      '',
      2.809395,
      '014',
      '',
      '',
      NULL,
      NULL,
      '3344',
      '',
      0.448550,
      1.350178,
      NULL,
      0.978646,
      3.344756,
      1,
      3.411323,
      3.461386,
      0.839974);
commit;
end;
/


